/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.gui.element;

import com.mojang.blaze3d.systems.RenderSystem;
import de.johni0702.minecraft.gui.GuiRenderer;
import de.johni0702.minecraft.gui.RenderInfo;
import de.johni0702.minecraft.gui.container.GuiContainer;
import de.johni0702.minecraft.gui.element.AbstractGuiClickable;
import de.johni0702.minecraft.gui.element.IGuiButton;
import de.johni0702.minecraft.gui.function.Clickable;
import de.johni0702.minecraft.gui.utils.lwjgl.Dimension;
import de.johni0702.minecraft.gui.utils.lwjgl.Point;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadableDimension;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadablePoint;
import de.johni0702.minecraft.gui.versions.MCVer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public abstract class AbstractGuiButton<T extends AbstractGuiButton<T>>
extends AbstractGuiClickable<T>
implements Clickable,
IGuiButton<T> {
    protected static final ResourceLocation BUTTON_SOUND = new ResourceLocation("gui.button.press");
    protected static final ResourceLocation WIDGETS_TEXTURE = new ResourceLocation("textures/gui/widgets.png");
    private SoundEvent sound = (SoundEvent)SoundEvents.f_12490_.m_203334_();
    private int labelColor = 0xE0E0E0;
    private String label;
    private ResourceLocation texture;
    private ReadableDimension textureSize;
    private ReadablePoint spriteUV;
    private ReadableDimension spriteSize;

    public AbstractGuiButton() {
    }

    public AbstractGuiButton(GuiContainer container) {
        super(container);
    }

    @Override
    public void draw(GuiRenderer renderer, ReadableDimension size, RenderInfo renderInfo) {
        super.draw(renderer, size, renderInfo);
        int texture = 1;
        int color = this.labelColor;
        if (!this.isEnabled()) {
            texture = 0;
            color = 0xA0A0A0;
        } else if (this.isMouseHovering((ReadablePoint)new Point(renderInfo.mouseX, renderInfo.mouseY))) {
            texture = 2;
            color = 0xFFFFA0;
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.blendFunc((int)770, (int)771);
        int textureY = 46 + texture * 20;
        int halfWidth = size.getWidth() / 2;
        int secondHalfWidth = size.getWidth() - halfWidth;
        int halfHeight = size.getHeight() / 2;
        int secondHalfHeight = size.getHeight() - halfHeight;
        renderer.bindTexture(WIDGETS_TEXTURE);
        renderer.drawTexturedRect(0, 0, 0, textureY, halfWidth, halfHeight);
        renderer.drawTexturedRect(0, halfHeight, 0, textureY + 20 - secondHalfHeight, halfWidth, secondHalfHeight);
        renderer.drawTexturedRect(halfWidth, 0, 200 - secondHalfWidth, textureY, secondHalfWidth, halfHeight);
        renderer.drawTexturedRect(halfWidth, halfHeight, 200 - secondHalfWidth, textureY + 20 - secondHalfHeight, secondHalfWidth, secondHalfHeight);
        if (this.texture != null) {
            renderer.bindTexture(this.texture);
            if (this.spriteUV != null && this.textureSize != null) {
                ReadableDimension spriteSize = this.spriteSize != null ? this.spriteSize : this.getMinSize();
                renderer.drawTexturedRect(0, 0, this.spriteUV.getX(), this.spriteUV.getY(), size.getWidth(), size.getHeight(), spriteSize.getWidth(), spriteSize.getHeight(), this.textureSize.getWidth(), this.textureSize.getHeight());
            } else {
                renderer.drawTexturedRect(0, 0, 0, 0, size.getWidth(), size.getHeight());
            }
        }
        if (this.label != null) {
            renderer.drawCenteredString(halfWidth, (size.getHeight() - 8) / 2, color, this.label, true);
        }
    }

    @Override
    public ReadableDimension calcMinSize() {
        if (this.label != null) {
            Font fontRenderer = MCVer.getFontRenderer();
            return new Dimension(fontRenderer.m_92895_(this.label), 20);
        }
        return new Dimension(0, 0);
    }

    @Override
    public void onClick() {
        AbstractGuiButton.playClickSound(this.getMinecraft());
        super.onClick();
    }

    public static void playClickSound(Minecraft mc) {
        AbstractGuiButton.playClickSound(mc, (SoundEvent)SoundEvents.f_12490_.m_203334_());
    }

    public static void playClickSound(Minecraft mc, SoundEvent sound) {
        mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)sound, (float)1.0f));
    }

    @Override
    public T setLabel(String label) {
        this.label = label;
        return (T)((AbstractGuiButton)this.getThis());
    }

    @Override
    public T setSound(SoundEvent sound) {
        this.sound = sound;
        return (T)((AbstractGuiButton)this.getThis());
    }

    public SoundEvent getSound() {
        return this.sound;
    }

    @Override
    public T setI18nLabel(String label, Object ... args) {
        return (T)this.setLabel(I18n.m_118938_((String)label, (Object[])args));
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public void setLabelColor(int labelColor) {
        this.labelColor = labelColor;
    }

    @Override
    public ResourceLocation getTexture() {
        return this.texture;
    }

    @Override
    public T setTexture(ResourceLocation texture) {
        this.texture = texture;
        return (T)((AbstractGuiButton)this.getThis());
    }

    @Override
    public ReadableDimension getTextureSize() {
        return this.textureSize;
    }

    @Override
    public T setTextureSize(ReadableDimension textureSize) {
        this.textureSize = textureSize;
        return (T)((AbstractGuiButton)this.getThis());
    }

    @Override
    public ReadablePoint getSpriteUV() {
        return this.spriteUV;
    }

    @Override
    public T setSpriteUV(ReadablePoint spriteUV) {
        this.spriteUV = spriteUV;
        return (T)((AbstractGuiButton)this.getThis());
    }

    @Override
    public ReadableDimension getSpriteSize() {
        return this.spriteSize;
    }

    @Override
    public T setSpriteSize(ReadableDimension spriteSize) {
        this.spriteSize = spriteSize;
        return (T)((AbstractGuiButton)this.getThis());
    }
}

