/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.gui.container;

import de.johni0702.minecraft.gui.container.AbstractGuiScreen;
import de.johni0702.minecraft.gui.container.GuiScreen;
import de.johni0702.minecraft.gui.function.Draggable;
import de.johni0702.minecraft.gui.function.Scrollable;
import de.johni0702.minecraft.gui.function.Tickable;
import de.johni0702.minecraft.gui.function.Typeable;
import de.johni0702.minecraft.gui.utils.EventRegistrations;
import de.johni0702.minecraft.gui.utils.MouseUtils;
import de.johni0702.minecraft.gui.utils.lwjgl.Point;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadablePoint;
import de.johni0702.minecraft.gui.versions.MCVer;
import de.johni0702.minecraft.gui.versions.callbacks.InitScreenCallback;
import de.johni0702.minecraft.gui.versions.callbacks.KeyboardCallback;
import de.johni0702.minecraft.gui.versions.callbacks.MouseCallback;
import de.johni0702.minecraft.gui.versions.callbacks.OpenGuiScreenCallback;
import de.johni0702.minecraft.gui.versions.callbacks.PostRenderScreenCallback;
import de.johni0702.minecraft.gui.versions.callbacks.PreTickCallback;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;

public class VanillaGuiScreen
extends GuiScreen
implements Draggable,
Typeable,
Scrollable,
Tickable {
    private static final Map<Screen, VanillaGuiScreen> WRAPPERS = Collections.synchronizedMap(new WeakHashMap());
    private final Screen mcScreen;
    private final EventHandler eventHandler = new EventHandler();

    public static VanillaGuiScreen wrap(Screen originalGuiScreen) {
        VanillaGuiScreen gui = WRAPPERS.get(originalGuiScreen);
        if (gui == null) {
            gui = new VanillaGuiScreen(originalGuiScreen);
            WRAPPERS.put(originalGuiScreen, gui);
            gui.register();
        }
        return gui;
    }

    @Deprecated
    public static VanillaGuiScreen setup(Screen originalGuiScreen) {
        VanillaGuiScreen gui = new VanillaGuiScreen(originalGuiScreen);
        gui.register();
        return gui;
    }

    public VanillaGuiScreen(Screen mcScreen) {
        this.mcScreen = mcScreen;
        this.suppressVanillaKeys = true;
        super.setBackground(AbstractGuiScreen.Background.NONE);
    }

    public void register() {
        if (!this.eventHandler.active) {
            this.eventHandler.active = true;
            this.eventHandler.register();
            this.getSuperMcGui().m_6575_(MCVer.getMinecraft(), this.mcScreen.f_96543_, this.mcScreen.f_96544_);
        }
    }

    @Override
    public void display() {
        this.getMinecraft().m_91152_(this.mcScreen);
        this.register();
    }

    @Override
    public Screen toMinecraft() {
        return this.mcScreen;
    }

    @Override
    public void setBackground(AbstractGuiScreen.Background background) {
        throw new UnsupportedOperationException("Cannot set background of vanilla gui screen.");
    }

    private Screen getSuperMcGui() {
        return super.toMinecraft();
    }

    @Override
    public boolean mouseClick(ReadablePoint position, int button) {
        return false;
    }

    @Override
    public boolean mouseDrag(ReadablePoint position, int button, long timeSinceLastCall) {
        return false;
    }

    @Override
    public boolean mouseRelease(ReadablePoint position, int button) {
        return false;
    }

    @Override
    public boolean scroll(ReadablePoint mousePosition, int dWheel) {
        return false;
    }

    @Override
    public boolean typeKey(ReadablePoint mousePosition, int keyCode, char keyChar, boolean ctrlDown, boolean shiftDown) {
        return false;
    }

    @Override
    public void tick() {
        if (this.getSuperMcGui() == this.getMinecraft().f_91080_) {
            this.getMinecraft().m_91152_(null);
        }
    }

    private class EventHandler
    extends EventRegistrations
    implements KeyboardCallback,
    MouseCallback {
        private boolean active;

        private EventHandler() {
            this.on(OpenGuiScreenCallback.EVENT, screen -> this.onGuiClosed());
            this.on(InitScreenCallback.Pre.EVENT, this::preGuiInit);
            this.on(PostRenderScreenCallback.EVENT, this::onGuiRender);
            this.on(PreTickCallback.EVENT, this::tickOverlay);
            this.on(MouseCallback.EVENT, this);
            this.on(KeyboardCallback.EVENT, this);
        }

        private void onGuiClosed() {
            this.unregister();
            if (this.active) {
                this.active = false;
                VanillaGuiScreen.this.getSuperMcGui().m_7861_();
                WRAPPERS.remove(VanillaGuiScreen.this.mcScreen, VanillaGuiScreen.this);
            }
        }

        private void preGuiInit(Screen screen) {
            if (screen == VanillaGuiScreen.this.mcScreen && this.active) {
                this.active = false;
                this.unregister();
                VanillaGuiScreen.this.getSuperMcGui().m_7861_();
                WRAPPERS.remove(VanillaGuiScreen.this.mcScreen, VanillaGuiScreen.this);
            }
        }

        private void onGuiRender(GuiGraphics stack, float partialTicks) {
            stack.m_280262_();
            Point mousePos = MouseUtils.getMousePos();
            VanillaGuiScreen.this.getSuperMcGui().m_88315_(stack, mousePos.getX(), mousePos.getY(), partialTicks);
        }

        private void tickOverlay() {
            VanillaGuiScreen.this.getSuperMcGui().m_86600_();
        }

        @Override
        public boolean mouseDown(double x, double y, int button) {
            return VanillaGuiScreen.this.getSuperMcGui().m_6375_(x, y, button);
        }

        @Override
        public boolean mouseDrag(double x, double y, int button, double dx, double dy) {
            return VanillaGuiScreen.this.getSuperMcGui().m_7979_(x, y, button, dx, dy);
        }

        @Override
        public boolean mouseUp(double x, double y, int button) {
            return VanillaGuiScreen.this.getSuperMcGui().m_6348_(x, y, button);
        }

        @Override
        public boolean mouseScroll(double x, double y, double horizontal, double vertical) {
            return VanillaGuiScreen.this.getSuperMcGui().m_6050_(x, y, vertical);
        }

        @Override
        public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
            return VanillaGuiScreen.this.getSuperMcGui().m_7933_(keyCode, scanCode, modifiers);
        }

        @Override
        public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
            return VanillaGuiScreen.this.getSuperMcGui().m_7920_(keyCode, scanCode, modifiers);
        }

        @Override
        public boolean charTyped(char keyChar, int scanCode) {
            return VanillaGuiScreen.this.getSuperMcGui().m_5534_(keyChar, scanCode);
        }
    }
}

