/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.gui.container;

import de.johni0702.minecraft.gui.GuiRenderer;
import de.johni0702.minecraft.gui.OffsetGuiRenderer;
import de.johni0702.minecraft.gui.RenderInfo;
import de.johni0702.minecraft.gui.container.AbstractGuiContainer;
import de.johni0702.minecraft.gui.container.GuiContainer;
import de.johni0702.minecraft.gui.element.GuiElement;
import de.johni0702.minecraft.gui.function.Scrollable;
import de.johni0702.minecraft.gui.utils.lwjgl.Dimension;
import de.johni0702.minecraft.gui.utils.lwjgl.Point;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadableDimension;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadablePoint;
import de.johni0702.minecraft.gui.utils.lwjgl.WritablePoint;

public abstract class AbstractGuiScrollable<T extends AbstractGuiScrollable<T>>
extends AbstractGuiContainer<T>
implements Scrollable {
    private int offsetX;
    private int offsetY;
    private final ReadablePoint negativeOffset = new ReadablePoint(){

        public int getX() {
            return -AbstractGuiScrollable.this.offsetX;
        }

        public int getY() {
            return -AbstractGuiScrollable.this.offsetY;
        }

        public void getLocation(WritablePoint dest) {
            dest.setLocation(this.getX(), this.getY());
        }
    };
    private Direction scrollDirection = Direction.VERTICAL;
    protected ReadableDimension lastRenderSize;

    public AbstractGuiScrollable() {
    }

    public AbstractGuiScrollable(GuiContainer container) {
        super(container);
    }

    @Override
    public void convertFor(GuiElement element, Point point, int relativeLayer) {
        super.convertFor(element, point, relativeLayer);
        if (relativeLayer > 0 || point.getX() > 0 && point.getX() < this.lastRenderSize.getWidth() && point.getY() > 0 && point.getY() < this.lastRenderSize.getHeight()) {
            point.translate(this.offsetX, this.offsetY);
        } else {
            point.setLocation(Integer.MIN_VALUE, Integer.MIN_VALUE);
        }
    }

    @Override
    public void layout(ReadableDimension size, RenderInfo renderInfo) {
        if (size != null) {
            int width = size.getWidth();
            int height = size.getHeight();
            this.lastRenderSize = size;
            size = super.calcMinSize();
            size = new Dimension(Math.max(width, size.getWidth()), Math.max(height, size.getHeight()));
            renderInfo = renderInfo.offsetMouse(-this.offsetX, -this.offsetY);
        }
        super.layout(size, renderInfo);
    }

    @Override
    public void draw(GuiRenderer renderer, ReadableDimension size, RenderInfo renderInfo) {
        int width = size.getWidth();
        int height = size.getHeight();
        size = super.calcMinSize();
        size = new Dimension(Math.max(width, size.getWidth()), Math.max(height, size.getHeight()));
        renderInfo = renderInfo.offsetMouse(-this.offsetX, -this.offsetY);
        OffsetGuiRenderer offsetRenderer = new OffsetGuiRenderer(renderer, this.negativeOffset, size, renderInfo.layer == 0);
        offsetRenderer.startUsing();
        super.draw(offsetRenderer, size, renderInfo);
        offsetRenderer.stopUsing();
    }

    @Override
    public ReadableDimension calcMinSize() {
        return new Dimension(0, 0);
    }

    @Override
    public boolean scroll(ReadablePoint mousePosition, int dWheel) {
        Point mouse = new Point(mousePosition);
        if (this.getContainer() != null) {
            this.getContainer().convertFor(this, mouse);
        }
        if (mouse.getX() > 0 && mouse.getY() > 0 && mouse.getX() < this.lastRenderSize.getWidth() && mouse.getY() < this.lastRenderSize.getHeight()) {
            dWheel = (int)Math.copySign(Math.ceil((double)Math.abs(dWheel) / 4.0), (double)dWheel);
            if (this.scrollDirection == Direction.HORIZONTAL) {
                this.scrollX(dWheel);
            } else {
                this.scrollY(dWheel);
            }
            return true;
        }
        return false;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public T setOffsetX(int offsetX) {
        this.offsetX = offsetX;
        return (T)((AbstractGuiScrollable)this.getThis());
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public T setOffsetY(int offsetY) {
        this.offsetY = offsetY;
        return (T)((AbstractGuiScrollable)this.getThis());
    }

    public Direction getScrollDirection() {
        return this.scrollDirection;
    }

    public T setScrollDirection(Direction scrollDirection) {
        this.scrollDirection = scrollDirection;
        return (T)((AbstractGuiScrollable)this.getThis());
    }

    public T scrollX(int dPixel) {
        this.offsetX = Math.max(0, Math.min(super.calcMinSize().getWidth() - this.lastRenderSize.getWidth(), this.offsetX - dPixel));
        return (T)((AbstractGuiScrollable)this.getThis());
    }

    public T scrollY(int dPixel) {
        this.offsetY = Math.max(0, Math.min(super.calcMinSize().getHeight() - this.lastRenderSize.getHeight(), this.offsetY - dPixel));
        return (T)((AbstractGuiScrollable)this.getThis());
    }

    public static enum Direction {
        VERTICAL,
        HORIZONTAL;

    }
}

