/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.util;

import com.github.steveice10.packetlib.io.stream.StreamNetInput;
import com.github.steveice10.packetlib.io.stream.StreamNetOutput;
import com.replaymod.replaystudio.PacketData;
import com.replaymod.replaystudio.io.ReplayInputStream;
import com.replaymod.replaystudio.lib.guava.base.Optional;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.packet.State;
import com.replaymod.replaystudio.protocol.Packet;
import com.replaymod.replaystudio.protocol.PacketTypeRegistry;
import com.replaymod.replaystudio.replay.ReplayFile;
import com.replaymod.replaystudio.replay.ReplayMetaData;
import com.replaymod.replaystudio.util.Location;
import com.replaymod.replaystudio.util.PacketUtils;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.function.Consumer;

public class EntityPositionTracker {
    private static final String CACHE_ENTRY = "entity_positions.bin";
    private static final String OLD_CACHE_ENTRY = "entity_positions.json";
    private final ReplayFile replayFile;
    private volatile Map<Integer, NavigableMap<Long, Location>> entityPositions;

    public EntityPositionTracker(ReplayFile replayFile) {
        this.replayFile = replayFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(Consumer<Double> progressMonitor) throws IOException {
        Optional<InputStream> cached;
        ReplayFile replayFile = this.replayFile;
        synchronized (replayFile) {
            Optional<InputStream> oldCache = this.replayFile.get(OLD_CACHE_ENTRY);
            if (oldCache.isPresent()) {
                oldCache.get().close();
                this.replayFile.remove(OLD_CACHE_ENTRY);
            }
            cached = this.replayFile.getCache(CACHE_ENTRY);
        }
        if (cached.isPresent()) {
            Object object;
            try {
                InputStream in = cached.get();
                object = null;
                try {
                    this.loadFromCache(in);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (in != null) {
                        if (object != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            in.close();
                        }
                    }
                }
            }
            catch (EOFException e) {
                this.loadFromPacketData(progressMonitor);
                object = this.replayFile;
                synchronized (object) {
                    this.replayFile.removeCache(CACHE_ENTRY);
                }
                this.saveToCache();
            }
        } else {
            this.loadFromPacketData(progressMonitor);
            this.saveToCache();
        }
    }

    private void loadFromCache(InputStream rawIn) throws IOException {
        StreamNetInput in = new StreamNetInput(rawIn);
        this.entityPositions = new TreeMap<Integer, NavigableMap<Long, Location>>();
        for (int i = in.readVarInt(); i > 0; --i) {
            int entityId = in.readVarInt();
            TreeMap<Long, Location> locationMap = new TreeMap<Long, Location>();
            long time = 0L;
            for (int j = in.readVarInt(); j > 0; --j) {
                locationMap.put(time += in.readVarLong(), new Location(in.readDouble(), in.readDouble(), in.readDouble(), in.readFloat(), in.readFloat()));
            }
            this.entityPositions.put(entityId, locationMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToCache() throws IOException {
        ReplayFile replayFile = this.replayFile;
        synchronized (replayFile) {
            Optional<InputStream> cached = this.replayFile.getCache(CACHE_ENTRY);
            if (cached.isPresent()) {
                cached.get().close();
                return;
            }
            try (OutputStream rawOut = this.replayFile.writeCache(CACHE_ENTRY);){
                StreamNetOutput out = new StreamNetOutput(rawOut);
                out.writeVarInt(this.entityPositions.size());
                for (Map.Entry<Integer, NavigableMap<Long, Location>> entry : this.entityPositions.entrySet()) {
                    out.writeVarInt(entry.getKey());
                    out.writeVarInt(entry.getValue().size());
                    long time = 0L;
                    for (Map.Entry locEntry : entry.getValue().entrySet()) {
                        out.writeVarLong((Long)locEntry.getKey() - time);
                        time = (Long)locEntry.getKey();
                        Location loc = (Location)locEntry.getValue();
                        out.writeDouble(loc.getX());
                        out.writeDouble(loc.getY());
                        out.writeDouble(loc.getZ());
                        out.writeFloat(loc.getYaw());
                        out.writeFloat(loc.getPitch());
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromPacketData(Consumer<Double> progressMonitor) throws IOException {
        ReplayInputStream origIn;
        int replayLength;
        ReplayFile replayFile = this.replayFile;
        synchronized (replayFile) {
            ReplayMetaData metaData = this.replayFile.getMetaData();
            replayLength = Math.max(1, metaData.getDuration());
            origIn = this.replayFile.getPacketData(PacketTypeRegistry.get(metaData.getProtocolVersion(), State.LOGIN));
        }
        HashMap<Integer, NavigableMap<Long, Location>> entityPositions = new HashMap<Integer, NavigableMap<Long, Location>>();
        try (ReplayInputStream in = origIn;){
            PacketData packetData;
            while ((packetData = in.readPacket()) != null) {
                Location oldPosition;
                Location newPosition;
                Packet packet = packetData.getPacket();
                Integer entityID = PacketUtils.getEntityId(packet);
                if (entityID == null) {
                    packet.release();
                    continue;
                }
                TreeMap<Long, Location> positions = (TreeMap<Long, Location>)entityPositions.get(entityID);
                if (positions == null) {
                    positions = new TreeMap<Long, Location>();
                    entityPositions.put(entityID, positions);
                }
                if ((newPosition = PacketUtils.updateLocation(oldPosition = positions.isEmpty() ? null : (Location)positions.lastEntry().getValue(), packet)) != null) {
                    positions.put(packetData.getTime(), newPosition);
                    double progress = (double)packetData.getTime() / (double)replayLength;
                    progressMonitor.accept(Math.min(1.0, Math.max(0.0, progress)));
                }
                packet.release();
            }
        }
        this.entityPositions = entityPositions;
    }

    public Location getEntityPositionAtTimestamp(int entityID, long timestamp) {
        if (this.entityPositions == null) {
            throw new IllegalStateException("Not yet initialized.");
        }
        NavigableMap<Long, Location> positions = this.entityPositions.get(entityID);
        if (positions == null) {
            return null;
        }
        Map.Entry<Long, Location> lower = positions.floorEntry(timestamp);
        Map.Entry<Long, Location> higher = positions.higherEntry(timestamp);
        if (lower == null || higher == null) {
            return null;
        }
        double r = (higher.getKey() - timestamp) / (higher.getKey() - lower.getKey());
        Location l = lower.getValue();
        Location h = higher.getValue();
        return new Location(l.getX() + (h.getX() - l.getX()) * r, l.getY() + (h.getY() - l.getY()) * r, l.getZ() + (h.getZ() - l.getZ()) * r, l.getYaw() + (h.getYaw() - l.getYaw()) * (float)r, l.getPitch() + (h.getPitch() - l.getPitch()) * (float)r);
    }
}

