/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.replay;

import com.replaymod.replaystudio.data.Marker;
import com.replaymod.replaystudio.data.ModInfo;
import com.replaymod.replaystudio.data.ReplayAssetEntry;
import com.replaymod.replaystudio.io.ReplayInputStream;
import com.replaymod.replaystudio.io.ReplayOutputStream;
import com.replaymod.replaystudio.lib.guava.base.Optional;
import com.replaymod.replaystudio.pathing.PathingRegistry;
import com.replaymod.replaystudio.pathing.path.Timeline;
import com.replaymod.replaystudio.protocol.PacketTypeRegistry;
import com.replaymod.replaystudio.replay.ReplayMetaData;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;

public interface ReplayFile
extends Closeable {
    public Optional<InputStream> get(String var1) throws IOException;

    public Optional<InputStream> getCache(String var1) throws IOException;

    public Map<String, InputStream> getAll(Pattern var1) throws IOException;

    public OutputStream write(String var1) throws IOException;

    public OutputStream writeCache(String var1) throws IOException;

    public void remove(String var1) throws IOException;

    public void removeCache(String var1) throws IOException;

    public void save() throws IOException;

    public void saveTo(File var1) throws IOException;

    public ReplayMetaData getMetaData() throws IOException;

    public void writeMetaData(PacketTypeRegistry var1, ReplayMetaData var2) throws IOException;

    public ReplayInputStream getPacketData(PacketTypeRegistry var1) throws IOException;

    public ReplayOutputStream writePacketData() throws IOException;

    public Map<Integer, String> getResourcePackIndex() throws IOException;

    public void writeResourcePackIndex(Map<Integer, String> var1) throws IOException;

    public Optional<InputStream> getResourcePack(String var1) throws IOException;

    public OutputStream writeResourcePack(String var1) throws IOException;

    public Map<String, Timeline> getTimelines(PathingRegistry var1) throws IOException;

    public void writeTimelines(PathingRegistry var1, Map<String, Timeline> var2) throws IOException;

    default public Optional<BufferedImage> getThumb() throws IOException {
        Optional<InputStream> maybeThumb = this.getThumbBytes();
        if (maybeThumb.isPresent()) {
            return Optional.of(ImageIO.read(maybeThumb.get()));
        }
        return Optional.absent();
    }

    default public void writeThumb(BufferedImage image) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "jpg", out);
        this.writeThumbBytes(out.toByteArray());
    }

    public Optional<InputStream> getThumbBytes() throws IOException;

    public void writeThumbBytes(byte[] var1) throws IOException;

    public Optional<Set<UUID>> getInvisiblePlayers() throws IOException;

    public void writeInvisiblePlayers(Set<UUID> var1) throws IOException;

    public Optional<Set<Marker>> getMarkers() throws IOException;

    public void writeMarkers(Set<Marker> var1) throws IOException;

    public Collection<ReplayAssetEntry> getAssets() throws IOException;

    public Optional<InputStream> getAsset(UUID var1) throws IOException;

    public OutputStream writeAsset(ReplayAssetEntry var1) throws IOException;

    public void removeAsset(UUID var1) throws IOException;

    public Collection<ModInfo> getModInfo() throws IOException;

    public void writeModInfo(Collection<ModInfo> var1) throws IOException;
}

