/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.rar.analyse;

import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.packetlib.io.NetOutput;
import com.replaymod.replaystudio.PacketData;
import com.replaymod.replaystudio.io.ReplayInputStream;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.version.ProtocolVersion;
import com.replaymod.replaystudio.protocol.Packet;
import com.replaymod.replaystudio.protocol.PacketType;
import com.replaymod.replaystudio.protocol.PacketTypeRegistry;
import com.replaymod.replaystudio.protocol.packets.PacketBlockChange;
import com.replaymod.replaystudio.protocol.packets.PacketChunkData;
import com.replaymod.replaystudio.protocol.packets.PacketConfigRegistries;
import com.replaymod.replaystudio.protocol.packets.PacketDestroyEntities;
import com.replaymod.replaystudio.protocol.packets.PacketJoinGame;
import com.replaymod.replaystudio.protocol.packets.PacketNotifyClient;
import com.replaymod.replaystudio.protocol.packets.PacketPlayerListEntry;
import com.replaymod.replaystudio.protocol.packets.PacketRespawn;
import com.replaymod.replaystudio.protocol.packets.PacketSpawnPlayer;
import com.replaymod.replaystudio.protocol.packets.PacketUpdateLight;
import com.replaymod.replaystudio.protocol.packets.PacketUpdateSimulationDistance;
import com.replaymod.replaystudio.protocol.packets.PacketUpdateViewDistance;
import com.replaymod.replaystudio.protocol.packets.PacketUpdateViewPosition;
import com.replaymod.replaystudio.rar.cache.WriteableCache;
import com.replaymod.replaystudio.rar.state.Chunk;
import com.replaymod.replaystudio.rar.state.Entity;
import com.replaymod.replaystudio.rar.state.Replay;
import com.replaymod.replaystudio.rar.state.TransientThing;
import com.replaymod.replaystudio.rar.state.World;
import com.replaymod.replaystudio.util.IPosition;
import com.replaymod.replaystudio.util.Location;
import com.replaymod.replaystudio.util.PacketUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.IntConsumer;

public class ReplayAnalyzer {
    private final PacketTypeRegistry registry;
    private final NetOutput out;
    private final Replay.Builder replay;
    private int currentViewChunkX = 0;
    private int currentViewChunkZ = 0;
    private int currentViewDistance = 0;
    private int currentSimulationDistance = 0;
    private final Map<String, PacketPlayerListEntry> playerListEntries = new HashMap<String, PacketPlayerListEntry>();
    private CompoundTag lastRegistry = null;
    private Packet lastLightUpdate = null;

    public ReplayAnalyzer(PacketTypeRegistry registry, NetOutput out, WriteableCache cache) throws IOException {
        this.registry = registry;
        this.out = out;
        this.replay = new Replay.Builder(registry, cache);
    }

    public void analyse(ReplayInputStream in, IntConsumer progress) throws IOException {
        PacketData packetData;
        int time = 0;
        while ((packetData = in.readPacket()) != null) {
            Location location;
            Location updated;
            Object entity;
            Packet packet = packetData.getPacket();
            time = (int)packetData.getTime();
            progress.accept(time);
            Integer entityId = PacketUtils.getEntityId(packet);
            PacketType type = packet.getType();
            block0 : switch (type) {
                case SpawnPlayer: 
                case SpawnMob: 
                case SpawnObject: 
                case SpawnPainting: {
                    PacketPlayerListEntry packetPlayerListEntry;
                    entity = this.replay.world.transientThings.newEntity(time, entityId);
                    if (type == (packet.atLeast(ProtocolVersion.v1_20_2) ? PacketType.SpawnObject : PacketType.SpawnPlayer) && (packetPlayerListEntry = this.playerListEntries.get(PacketSpawnPlayer.getPlayerListEntryId(packet))) != null) {
                        ((TransientThing.Builder)entity).addSpawnPacket(PacketPlayerListEntry.write(this.registry, PacketPlayerListEntry.Action.init(this.registry), packetPlayerListEntry));
                    }
                    ((TransientThing.Builder)entity).addSpawnPacket(packet.retain());
                    break;
                }
                case DestroyEntity: 
                case DestroyEntities: {
                    entity = PacketDestroyEntities.getEntityIds(packet).iterator();
                    while (entity.hasNext()) {
                        int n = entity.next();
                        this.replay.world.transientThings.removeEntity(time, n);
                    }
                    break;
                }
                case UnloadChunk: 
                case ChunkData: {
                    PacketChunkData chunkData = PacketChunkData.read(packet, this.replay.world.info.dimensionType.getSections());
                    if (chunkData.isUnload()) {
                        this.replay.world.transientThings.removeChunk(time, chunkData.getUnloadX(), chunkData.getUnloadZ());
                        break;
                    }
                    this.processChunkLoad(time, chunkData.getColumn());
                    break;
                }
                case BulkChunkData: {
                    for (PacketChunkData.Column column : PacketChunkData.readBulk(packet)) {
                        this.processChunkLoad(time, column);
                    }
                    break;
                }
                case UpdateLight: {
                    if (this.registry.atLeast(ProtocolVersion.v1_18)) break;
                    PacketUpdateLight updateLight = PacketUpdateLight.read(packet);
                    Chunk.Builder builder = this.replay.world.transientThings.getChunk(updateLight.getX(), updateLight.getZ());
                    if (builder != null && builder.spawnPackets.list.size() == 1) {
                        builder.spawnPackets.list.add(0, packet.retain());
                        break;
                    }
                    if (this.lastLightUpdate != null) {
                        this.lastLightUpdate.release();
                    }
                    this.lastLightUpdate = packet.retain();
                    break;
                }
                case BlockChange: 
                case MultiBlockChange: {
                    for (PacketBlockChange packetBlockChange : PacketBlockChange.readSingleOrBulk(packet)) {
                        IPosition pos = packetBlockChange.getPosition();
                        Chunk.Builder chunk = this.replay.world.transientThings.getChunk(pos.getX() >> 4, pos.getZ() >> 4);
                        if (chunk == null) continue;
                        chunk.blocks.update(time, packetBlockChange);
                    }
                    break;
                }
                case PlayerListEntry: {
                    Set<PacketPlayerListEntry.Action> actions = PacketPlayerListEntry.getActions(packet);
                    for (PacketPlayerListEntry entry : PacketPlayerListEntry.read(packet)) {
                        for (PacketPlayerListEntry.Action action : actions) {
                            switch (action) {
                                case ADD: {
                                    this.playerListEntries.put(entry.getId(), entry);
                                    break;
                                }
                                case CHAT_KEY: {
                                    this.playerListEntries.computeIfPresent(entry.getId(), (key, it) -> PacketPlayerListEntry.updateChatKey(it, entry.getSigData()));
                                    break;
                                }
                                case GAMEMODE: {
                                    this.playerListEntries.computeIfPresent(entry.getId(), (key, it) -> PacketPlayerListEntry.updateGamemode(it, entry.getGamemode()));
                                    break;
                                }
                                case LISTED: {
                                    this.playerListEntries.computeIfPresent(entry.getId(), (key, it) -> PacketPlayerListEntry.updateListed(it, entry.isListed()));
                                    break;
                                }
                                case LATENCY: {
                                    this.playerListEntries.computeIfPresent(entry.getId(), (key, it) -> PacketPlayerListEntry.updateLatency(it, entry.getLatency()));
                                    break;
                                }
                                case DISPLAY_NAME: {
                                    this.playerListEntries.computeIfPresent(entry.getId(), (key, it) -> PacketPlayerListEntry.updateDisplayName(it, entry.getDisplayName()));
                                    break;
                                }
                                case REMOVE: {
                                    this.playerListEntries.remove(entry.getId());
                                }
                            }
                        }
                    }
                    break;
                }
                case Respawn: {
                    PacketRespawn respawn = PacketRespawn.read(packet, this.replay.world.info.registries);
                    String string = respawn.dimension;
                    if (string.equals(this.replay.world.info.dimension)) break;
                    World.Builder world = this.replay.newWorld(time, new World.Info(this.replay.world.info, respawn));
                    if (this.registry.atLeast(ProtocolVersion.v1_14)) {
                        this.currentViewChunkZ = 0;
                        this.currentViewChunkX = 0;
                        world.viewPosition.put(time, PacketUpdateViewPosition.write(this.registry, 0, 0));
                        world.viewDistance.put(time, PacketUpdateViewDistance.write(this.registry, this.currentViewDistance));
                    }
                    if (!this.registry.atLeast(ProtocolVersion.v1_18)) break;
                    world.simulationDistance.put(time, PacketUpdateSimulationDistance.write(this.registry, this.currentSimulationDistance));
                    break;
                }
                case JoinGame: {
                    PacketJoinGame joinGame = PacketJoinGame.read(packet, this.lastRegistry);
                    this.replay.newWorld(time, new World.Info(joinGame, joinGame.registries));
                    if (this.registry.atLeast(ProtocolVersion.v1_14)) {
                        this.currentViewChunkZ = 0;
                        this.currentViewChunkX = 0;
                        this.replay.world.viewPosition.put(time, PacketUpdateViewPosition.write(this.registry, 0, 0));
                        this.currentViewDistance = joinGame.viewDistance;
                        this.replay.world.viewDistance.put(time, PacketUpdateViewDistance.write(this.registry, this.currentViewDistance));
                    }
                    if (!this.registry.atLeast(ProtocolVersion.v1_18)) break;
                    this.currentSimulationDistance = joinGame.simulationDistance;
                    this.replay.world.simulationDistance.put(time, PacketUpdateSimulationDistance.write(this.registry, this.currentSimulationDistance));
                    break;
                }
                case ConfigFeatures: 
                case Features: {
                    this.replay.features.put(time, packet.retain());
                    break;
                }
                case ConfigTags: {
                    this.replay.tags.put(time, new Packet(this.registry, PacketType.Tags, packet.getBuf().retain()));
                    break;
                }
                case Tags: {
                    this.replay.tags.put(time, packet.retain());
                    break;
                }
                case ConfigRegistries: {
                    this.lastRegistry = PacketConfigRegistries.read(packet);
                    break;
                }
                case UpdateViewPosition: {
                    this.currentViewChunkX = PacketUpdateViewPosition.getChunkX(packet);
                    this.currentViewChunkZ = PacketUpdateViewPosition.getChunkZ(packet);
                    this.invalidateOutOfBoundsChunks(time, this.currentViewChunkX, this.currentViewChunkZ, this.currentViewDistance);
                    this.replay.world.viewPosition.put(time, packet.retain());
                    break;
                }
                case UpdateViewDistance: {
                    this.currentViewDistance = PacketUpdateViewDistance.getDistance(packet);
                    this.invalidateOutOfBoundsChunks(time, this.currentViewChunkX, this.currentViewChunkZ, this.currentViewDistance);
                    this.replay.world.viewDistance.put(time, packet.retain());
                    break;
                }
                case UpdateSimulationDistance: {
                    this.currentSimulationDistance = PacketUpdateSimulationDistance.getDistance(packet);
                    this.replay.world.simulationDistance.put(time, packet.retain());
                    break;
                }
                case UpdateTime: {
                    this.replay.world.worldTimes.put(time, packet.retain());
                    break;
                }
                case NotifyClient: {
                    switch (PacketNotifyClient.getAction(packet)) {
                        case START_RAIN: {
                            this.replay.world.transientThings.newWeather(time);
                            break block0;
                        }
                        case STOP_RAIN: {
                            this.replay.world.transientThings.removeWeather(time);
                            break block0;
                        }
                        case RAIN_STRENGTH: {
                            this.replay.world.rainStrengths.put(time, packet.retain());
                            break block0;
                        }
                        case THUNDER_STRENGTH: {
                            this.replay.world.thunderStrengths.put(time, packet.retain());
                            break block0;
                        }
                    }
                }
            }
            if (entityId != null && (entity = this.replay.world.transientThings.getEntity(entityId)) != null && (updated = PacketUtils.updateLocation(location = ((Entity.Builder)entity).getLocation(), packet)) != null) {
                ((Entity.Builder)entity).updateLocation(time, updated);
            }
            packet.release();
        }
        if (this.lastLightUpdate != null) {
            this.lastLightUpdate.release();
        }
        this.replay.build(this.out, time);
    }

    private void processChunkLoad(int time, PacketChunkData.Column column) throws IOException {
        if (column.isFull()) {
            PacketUpdateLight updateLight;
            Chunk.Builder chunk = this.replay.world.transientThings.newChunk(time, column);
            if (this.lastLightUpdate != null && column.x == (updateLight = PacketUpdateLight.read(this.lastLightUpdate)).getX() && column.z == updateLight.getZ()) {
                chunk.spawnPackets.list.add(0, this.lastLightUpdate);
                this.lastLightUpdate = null;
            }
        } else {
            Chunk.Builder chunk = this.replay.world.transientThings.getChunk(column.x, column.z);
            if (chunk != null) {
                chunk.blocks.update(time, column);
            }
        }
    }

    private void invalidateOutOfBoundsChunks(int time, int centerX, int centerZ, int viewDistance) throws IOException {
        int distance = Math.max(2, viewDistance) + 3;
        LongOpenHashSet toBeRemoved = new LongOpenHashSet();
        for (Long2ObjectMap.Entry entry : this.replay.world.transientThings.getChunks().long2ObjectEntrySet()) {
            long key = entry.getLongKey();
            int x = PacketChunkData.Column.longToX(key);
            int z = PacketChunkData.Column.longToZ(key);
            if (Math.abs(x - centerX) <= distance && Math.abs(z - centerZ) <= distance) continue;
            toBeRemoved.add(key);
        }
        ObjectIterator objectIterator = toBeRemoved.iterator();
        while (objectIterator.hasNext()) {
            long key = (Long)objectIterator.next();
            this.replay.world.transientThings.removeChunk(time, key);
        }
    }
}

