/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.protocol.packets;

import com.replaymod.replaystudio.lib.viaversion.api.protocol.version.ProtocolVersion;
import com.replaymod.replaystudio.protocol.Packet;
import com.replaymod.replaystudio.protocol.PacketType;
import com.replaymod.replaystudio.protocol.PacketTypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;

public class PacketUpdateLight {
    private static final byte[] EMPTY = new byte[2048];
    private int x;
    private int z;
    private Data data;

    public static PacketUpdateLight read(Packet packet) throws IOException {
        if (packet.getType() != PacketType.UpdateLight) {
            throw new IllegalArgumentException("Can only read packets of type UpdateLight.");
        }
        PacketUpdateLight updateLight = new PacketUpdateLight();
        try (Packet.Reader reader = packet.reader();){
            updateLight.read(packet, reader);
        }
        return updateLight;
    }

    public Packet write(PacketTypeRegistry registry) throws IOException {
        Packet packet = new Packet(registry, PacketType.UpdateLight);
        try (Packet.Writer writer = packet.overwrite();){
            this.write(packet, writer);
        }
        return packet;
    }

    private PacketUpdateLight() {
    }

    public PacketUpdateLight(int x, int z, List<byte[]> skyLight, List<byte[]> blockLight) {
        this(x, z, new Data(skyLight, blockLight));
    }

    public PacketUpdateLight(int x, int z, Data data) {
        this.x = x;
        this.z = z;
        this.data = data;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public Data getData() {
        return this.data;
    }

    public List<byte[]> getSkyLight() {
        return this.data.skyLight;
    }

    public List<byte[]> getBlockLight() {
        return this.data.blockLight;
    }

    private void read(Packet packet, Packet.Reader in) throws IOException {
        this.x = in.readVarInt();
        this.z = in.readVarInt();
        this.data = PacketUpdateLight.readData(packet, in);
    }

    static Data readData(Packet packet, Packet.Reader in) throws IOException {
        int i;
        Data data = new Data();
        if (packet.atLeast(ProtocolVersion.v1_16) && packet.olderThan(ProtocolVersion.v1_20)) {
            in.readBoolean();
        }
        BitSet skyLightMask = in.readBitSet();
        BitSet blockLightMask = in.readBitSet();
        BitSet emptySkyLightMask = in.readBitSet();
        BitSet emptyBlockLightMask = in.readBitSet();
        int skySections = Math.max(skyLightMask.length(), emptySkyLightMask.length());
        int blockSections = Math.max(blockLightMask.length(), emptyBlockLightMask.length());
        if (packet.atLeast(ProtocolVersion.v1_17)) {
            int skyLightsSent = in.readVarInt();
            if (skyLightMask.cardinality() != skyLightsSent) {
                throw new IOException("Expected " + skyLightMask.cardinality() + " sky light sections but got " + skyLightsSent);
            }
        }
        data.skyLight = new ArrayList<byte[]>(skySections);
        for (i = 0; i < skySections; ++i) {
            if (skyLightMask.get(i)) {
                if (in.readVarInt() != 2048) {
                    throw new IOException("Expected sky light byte array to be of length 2048");
                }
                data.skyLight.add(in.readBytes(2048));
                continue;
            }
            if (emptySkyLightMask.get(i)) {
                data.skyLight.add(new byte[2048]);
                continue;
            }
            data.skyLight.add(null);
        }
        if (packet.atLeast(ProtocolVersion.v1_17)) {
            int blockLightsSent = in.readVarInt();
            if (blockLightMask.cardinality() != blockLightsSent) {
                throw new IOException("Expected " + blockLightMask.cardinality() + " block light sections but got " + blockLightsSent);
            }
        }
        data.blockLight = new ArrayList<byte[]>(blockSections);
        for (i = 0; i < blockSections; ++i) {
            if (blockLightMask.get(i)) {
                if (in.readVarInt() != 2048) {
                    throw new IOException("Expected block light byte array to be of length 2048");
                }
                data.blockLight.add(in.readBytes(2048));
                continue;
            }
            if (emptyBlockLightMask.get(i)) {
                data.blockLight.add(new byte[2048]);
                continue;
            }
            data.blockLight.add(null);
        }
        return data;
    }

    private void write(Packet packet, Packet.Writer out) throws IOException {
        out.writeVarInt(this.x);
        out.writeVarInt(this.z);
        PacketUpdateLight.writeData(packet, out, this.data);
    }

    static void writeData(Packet packet, Packet.Writer out, Data data) throws IOException {
        int i;
        if (packet.atLeast(ProtocolVersion.v1_16) && packet.olderThan(ProtocolVersion.v1_20)) {
            out.writeBoolean(true);
        }
        BitSet skyLightMask = new BitSet();
        BitSet blockLightMask = new BitSet();
        BitSet emptySkyLightMask = new BitSet();
        BitSet emptyBlockLightMask = new BitSet();
        ArrayList<byte[]> skyLights = new ArrayList<byte[]>();
        ArrayList<byte[]> blockLights = new ArrayList<byte[]>();
        for (i = 0; i < data.skyLight.size(); ++i) {
            byte[] skyLight = data.skyLight.get(i);
            if (skyLight == null) continue;
            if (Arrays.equals(EMPTY, skyLight)) {
                emptySkyLightMask.set(i);
                continue;
            }
            skyLightMask.set(i);
            skyLights.add(skyLight);
        }
        for (i = 0; i < data.blockLight.size(); ++i) {
            byte[] blockLight = data.blockLight.get(i);
            if (blockLight == null) continue;
            if (Arrays.equals(EMPTY, blockLight)) {
                emptyBlockLightMask.set(i);
                continue;
            }
            blockLightMask.set(i);
            blockLights.add(blockLight);
        }
        out.writeBitSet(skyLightMask);
        out.writeBitSet(blockLightMask);
        out.writeBitSet(emptySkyLightMask);
        out.writeBitSet(emptyBlockLightMask);
        if (packet.atLeast(ProtocolVersion.v1_17)) {
            out.writeVarInt(skyLights.size());
        }
        for (byte[] bytes : skyLights) {
            out.writeVarInt(2048);
            out.writeBytes(bytes);
        }
        if (packet.atLeast(ProtocolVersion.v1_17)) {
            out.writeVarInt(blockLights.size());
        }
        for (byte[] bytes : blockLights) {
            out.writeVarInt(2048);
            out.writeBytes(bytes);
        }
    }

    public static class Data {
        public List<byte[]> skyLight;
        public List<byte[]> blockLight;

        public Data() {
        }

        public Data(List<byte[]> skyLight, List<byte[]> blockLight) {
            this.skyLight = skyLight;
            this.blockLight = blockLight;
        }
    }
}

