/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.protocol.packets;

import com.replaymod.replaystudio.lib.viaversion.api.protocol.version.ProtocolVersion;
import com.replaymod.replaystudio.protocol.Packet;
import com.replaymod.replaystudio.protocol.PacketType;
import com.replaymod.replaystudio.protocol.PacketTypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class PacketTeam {
    public static String getName(Packet packet) throws IOException {
        try (Packet.Reader in = packet.reader();){
            String string = in.readString();
            return string;
        }
    }

    public static Action getAction(Packet packet) throws IOException {
        try (Packet.Reader in = packet.reader();){
            in.readString();
            Action action = Action.values()[in.readByte()];
            return action;
        }
    }

    public static List<String> getPlayers(Packet packet) throws IOException {
        try (Packet.Reader in = packet.reader();){
            in.readString();
            Action action = Action.values()[in.readByte()];
            if (action != Action.CREATE && action != Action.ADD_PLAYER && action != Action.REMOVE_PLAYER) {
                List<String> list = Collections.emptyList();
                return list;
            }
            if (action == Action.CREATE) {
                in.readText();
                if (!packet.atLeast(ProtocolVersion.v1_13)) {
                    in.readString();
                    in.readString();
                }
                in.readByte();
                if (packet.atLeast(ProtocolVersion.v1_8)) {
                    in.readString();
                    if (packet.atLeast(ProtocolVersion.v1_9)) {
                        in.readString();
                    }
                    if (packet.atLeast(ProtocolVersion.v1_13)) {
                        in.readVarInt();
                        in.readText();
                        in.readText();
                    } else {
                        in.readByte();
                    }
                }
            }
            int count = packet.atLeast(ProtocolVersion.v1_8) ? in.readVarInt() : (int)in.readShort();
            ArrayList<String> result = new ArrayList<String>(count);
            for (int i = 0; i < count; ++i) {
                result.add(in.readString());
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
    }

    public static Packet addPlayers(PacketTypeRegistry registry, String name, Collection<String> players) throws IOException {
        return PacketTeam.addOrRemovePlayers(registry, name, Action.ADD_PLAYER, players);
    }

    public static Packet removePlayers(PacketTypeRegistry registry, String name, Collection<String> players) throws IOException {
        return PacketTeam.addOrRemovePlayers(registry, name, Action.REMOVE_PLAYER, players);
    }

    private static Packet addOrRemovePlayers(PacketTypeRegistry registry, String name, Action action, Collection<String> players) throws IOException {
        Packet packet = new Packet(registry, PacketType.Team);
        try (Packet.Writer out = packet.overwrite();){
            out.writeString(name);
            out.writeByte(action.ordinal());
            if (packet.atLeast(ProtocolVersion.v1_8)) {
                out.writeVarInt(players.size());
            } else {
                out.writeShort(players.size());
            }
            for (String player : players) {
                out.writeString(player);
            }
        }
        return packet;
    }

    public static enum Action {
        CREATE,
        REMOVE,
        UPDATE,
        ADD_PLAYER,
        REMOVE_PLAYER;

    }
}

