/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.protocol.packets;

import com.replaymod.replaystudio.lib.viaversion.api.protocol.version.ProtocolVersion;
import com.replaymod.replaystudio.protocol.Packet;
import com.replaymod.replaystudio.protocol.packets.PacketDestroyEntities;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class EntityId {
    public static List<Integer> getEntityIds(Packet packet) throws IOException {
        switch (packet.getType()) {
            case EntityCollectItem: {
                try (Packet.Reader in = packet.reader();){
                    if (packet.atLeast(ProtocolVersion.v1_8)) {
                        List<Integer> list = Arrays.asList(in.readVarInt(), in.readVarInt());
                        return list;
                    }
                    List<Integer> list = Arrays.asList(in.readInt(), in.readInt());
                    return list;
                }
            }
            case DestroyEntities: {
                return PacketDestroyEntities.getEntityIds(packet);
            }
            case SetPassengers: {
                try (Packet.Reader in = packet.reader();){
                    int entityId = in.readVarInt();
                    int len = in.readVarInt();
                    ArrayList<Integer> result = new ArrayList<Integer>(len + 1);
                    result.add(entityId);
                    for (int i = 0; i < len; ++i) {
                        result.add(in.readVarInt());
                    }
                    ArrayList<Integer> arrayList = result;
                    return arrayList;
                }
            }
            case EntityAttach: {
                try (Packet.Reader in = packet.reader();){
                    List<Integer> entityId = Arrays.asList(in.readInt(), in.readInt());
                    return entityId;
                }
            }
            case Combat: {
                try (Packet.Reader in = packet.reader();){
                    int event = in.readVarInt();
                    if (event == 1) {
                        in.readVarInt();
                        List<Integer> list = Collections.singletonList(in.readInt());
                        return list;
                    }
                    if (event == 2) {
                        List<Integer> list = Arrays.asList(in.readVarInt(), in.readInt());
                        return list;
                    }
                    List<Integer> list = Collections.emptyList();
                    return list;
                }
            }
            case CombatEntityDead: {
                try (Packet.Reader in = packet.reader();){
                    if (packet.atLeast(ProtocolVersion.v1_20)) {
                        List<Integer> list = Collections.singletonList(in.readVarInt());
                        return list;
                    }
                    List<Integer> list = Arrays.asList(in.readVarInt(), in.readInt());
                    return list;
                }
            }
        }
        Integer entityId = EntityId.getEntityId(packet);
        if (entityId != null) {
            return Collections.singletonList(entityId);
        }
        return Collections.emptyList();
    }

    public static Integer getEntityId(Packet packet) throws IOException {
        switch (packet.getType()) {
            case OpenHorseWindow: {
                try (Packet.Reader in = packet.reader();){
                    in.readByte();
                    in.readVarInt();
                    Integer n = in.readInt();
                    return n;
                }
            }
            case EntitySoundEffect: {
                try (Packet.Reader in = packet.reader();){
                    in.readVarInt();
                    in.readVarInt();
                    Integer n = in.readVarInt();
                    return n;
                }
            }
            case EntityEffect: 
            case EntityRemoveEffect: 
            case EntityEquipment: 
            case EntityHeadLook: 
            case EntityMetadata: 
            case EntityMovement: 
            case EntityPosition: 
            case EntityRotation: 
            case EntityPositionRotation: 
            case EntityAnimation: 
            case EntityNBTUpdate: 
            case EntityProperties: 
            case EntityTeleport: 
            case EntityVelocity: 
            case SwitchCamera: 
            case PlayerUseBed: {
                try (Packet.Reader in = packet.reader();){
                    if (packet.atLeast(ProtocolVersion.v1_8)) {
                        Integer n = in.readVarInt();
                        return n;
                    }
                    Integer n = in.readInt();
                    return n;
                }
            }
            case BlockBreakAnim: 
            case DestroyEntity: 
            case SpawnPlayer: 
            case SpawnObject: 
            case SpawnPainting: 
            case SpawnMob: 
            case SpawnGlobalEntity: 
            case SpawnExpOrb: {
                try (Packet.Reader in = packet.reader();){
                    Integer n = in.readVarInt();
                    return n;
                }
            }
            case EntityStatus: {
                try (Packet.Reader in = packet.reader();){
                    Integer n = in.readInt();
                    return n;
                }
            }
            case CombatEnd: {
                try (Packet.Reader in = packet.reader();){
                    in.readVarInt();
                    if (packet.atLeast(ProtocolVersion.v1_20)) {
                        Integer n = null;
                        return n;
                    }
                    Integer n = in.readInt();
                    return n;
                }
            }
        }
        return null;
    }
}

