/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.protocol;

import com.replaymod.replaystudio.lib.guava.collect.Lists;
import com.replaymod.replaystudio.lib.viaversion.api.Via;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.AbstractProtocol;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.Protocol;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.ProtocolPathEntry;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.packet.ClientboundPacketType;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.packet.PacketWrapper;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.packet.State;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.packet.mapping.PacketMapping;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.packet.mapping.PacketMappings;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.packet.provider.PacketTypeMap;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.version.ProtocolVersion;
import com.replaymod.replaystudio.lib.viaversion.protocols.protocol1_14to1_13_2.Protocol1_14To1_13_2;
import com.replaymod.replaystudio.lib.viaversion.protocols.protocol1_16to1_15_2.Protocol1_16To1_15_2;
import com.replaymod.replaystudio.lib.viaversion.protocols.protocol1_17_1to1_17.Protocol1_17_1To1_17;
import com.replaymod.replaystudio.lib.viaversion.protocols.protocol1_17to1_16_4.Protocol1_17To1_16_4;
import com.replaymod.replaystudio.lib.viaversion.protocols.protocol1_19to1_18_2.Protocol1_19To1_18_2;
import com.replaymod.replaystudio.lib.viaversion.protocols.protocol1_20_3to1_20_2.Protocol1_20_3To1_20_2;
import com.replaymod.replaystudio.lib.viaversion.protocols.protocol1_9to1_8.Protocol1_9To1_8;
import com.replaymod.replaystudio.protocol.PacketType;
import com.replaymod.replaystudio.viaversion.CustomViaManager;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class PacketTypeRegistry {
    private static Map<ProtocolVersion, EnumMap<State, PacketTypeRegistry>> forVersionAndState = new HashMap<ProtocolVersion, EnumMap<State, PacketTypeRegistry>>();
    private static Field clientbound;
    private final ProtocolVersion version;
    private final State state;
    private final PacketType unknown;
    private final Map<Integer, PacketType> typeForId = new HashMap<Integer, PacketType>();
    private final Map<PacketType, Integer> idForType = new HashMap<PacketType, Integer>();

    public static PacketTypeRegistry get(ProtocolVersion version, State state) {
        EnumMap<State, PacketTypeRegistry> forState = forVersionAndState.get(version);
        return forState != null ? forState.get((Object)state) : new PacketTypeRegistry(version, state);
    }

    /*
     * Unable to fully structure code
     */
    private PacketTypeRegistry(ProtocolVersion version, State state) {
        super();
        this.version = version;
        this.state = state;
        unknown = null;
        versionIndex = ProtocolVersion.getIndex(version);
        block4: for (PacketType packetType : PacketType.values()) {
            if (packetType.getState() != state) continue;
            if (packetType.isUnknown()) {
                unknown = packetType;
                continue;
            }
            if (ProtocolVersion.getIndex(packetType.getInitialVersion()) > versionIndex || (protocolPath = PacketTypeRegistry.getProtocolPath(version.getVersion(), packetType.getInitialVersion().getVersion())) == null) continue;
            id = packetType.getInitialId();
            block5: for (ProtocolPathEntry entry : Lists.reverse(protocolPath)) {
                protocol = entry.getProtocol();
                wasReplaced = false;
                for (Pair<Integer, Integer> idMapping : PacketTypeRegistry.getIdMappings(protocol, state)) {
                    oldId = (Integer)idMapping.getKey();
                    newId = (Integer)idMapping.getValue();
                    if (oldId == id) {
                        if (newId == -1) {
                            if (!(protocol instanceof Protocol1_17To1_16_4) || packetType != PacketType.DestroyEntities || version == ProtocolVersion.v1_17) continue block4;
                            id = PacketType.DestroyEntity.getInitialId();
                            wasReplaced = false;
                            break;
                        }
                        id = newId;
                        wasReplaced = false;
                        break;
                    }
                    if (newId != id) continue;
                    wasReplaced = true;
                }
                if (!(protocol instanceof Protocol1_19To1_18_2)) ** GOTO lbl-1000
                switch (1.$SwitchMap$com$replaymod$replaystudio$protocol$PacketType[packetType.ordinal()]) {
                    case 1: 
                    case 2: {
                        continue block4;
                    }
                    case 3: {
                        wasReplaced = false;
                        id = 0;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        if (protocol instanceof Protocol1_16To1_15_2 && packetType == PacketType.SpawnGlobalEntity) {
                            wasReplaced = true;
                        }
                        if (protocol instanceof Protocol1_14To1_13_2 && packetType == PacketType.PlayerUseBed) {
                            wasReplaced = true;
                        }
                        if (protocol instanceof Protocol1_9To1_8 && packetType == PacketType.EntityNBTUpdate) {
                            wasReplaced = true;
                        }
                        if (protocol instanceof Protocol1_17_1To1_17 && packetType == PacketType.DestroyEntity) {
                            wasReplaced = true;
                        }
                        if (protocol instanceof Protocol1_20_3To1_20_2 && state == State.CONFIGURATION && id >= 7) {
                            ++id;
                        }
                        if (!wasReplaced) continue block5;
                        continue block4;
                    }
                }
            }
            this.typeForId.put(id, packetType);
            this.idForType.put(packetType, id);
        }
        this.unknown = unknown;
    }

    private static List<ProtocolPathEntry> getProtocolPath(int clientVersion, int serverVersion) {
        if (serverVersion == ProtocolVersion.v1_7_6.getVersion()) {
            return PacketTypeRegistry.getProtocolPath(clientVersion, ProtocolVersion.v1_8.getVersion());
        }
        if (clientVersion == ProtocolVersion.v1_7_6.getVersion()) {
            return PacketTypeRegistry.getProtocolPath(ProtocolVersion.v1_8.getVersion(), serverVersion);
        }
        if (clientVersion == serverVersion) {
            return Collections.emptyList();
        }
        return Via.getManager().getProtocolManager().getProtocolPath(clientVersion, serverVersion);
    }

    public ProtocolVersion getVersion() {
        return this.version;
    }

    public State getState() {
        return this.state;
    }

    public Integer getId(PacketType type) {
        return this.idForType.get((Object)type);
    }

    public PacketType getType(int id) {
        return this.typeForId.getOrDefault(id, this.unknown);
    }

    public boolean atLeast(ProtocolVersion protocolVersion) {
        return this.version.getVersion() >= protocolVersion.getVersion();
    }

    public boolean atMost(ProtocolVersion protocolVersion) {
        return this.version.getVersion() <= protocolVersion.getVersion();
    }

    public boolean olderThan(ProtocolVersion protocolVersion) {
        return this.version.getVersion() < protocolVersion.getVersion();
    }

    public PacketTypeRegistry withState(State state) {
        return PacketTypeRegistry.get(this.version, state);
    }

    public PacketTypeRegistry withLoginSuccess() {
        return this.withState(this.atLeast(ProtocolVersion.v1_20_2) ? State.CONFIGURATION : State.PLAY);
    }

    private static List<Pair<Integer, Integer>> getIdMappings(Protocol<?, ?, ?, ?> protocol, State state) {
        ArrayList<Pair<Integer, Integer>> result = new ArrayList<Pair<Integer, Integer>>();
        try {
            if (clientbound == null) {
                clientbound = AbstractProtocol.class.getDeclaredField("clientboundMappings");
                clientbound.setAccessible(true);
            }
            PacketMappings mappings = (PacketMappings)clientbound.get(protocol);
            PacketTypeMap<?> packetTypeMap = protocol.getPacketTypesProvider().unmappedClientboundPacketTypes().get((Object)state);
            if (packetTypeMap == null) {
                return result;
            }
            PacketWrapper dummyPacketWrapper = PacketWrapper.create(null, null);
            for (ClientboundPacketType unmappedPacketType : packetTypeMap.types()) {
                PacketMapping packetMapping = mappings.mappedPacket(state, unmappedPacketType.getId());
                if (packetMapping == null) continue;
                dummyPacketWrapper.setPacketType(null);
                packetMapping.applyType(dummyPacketWrapper);
                int oldId = unmappedPacketType.getId();
                int newId = dummyPacketWrapper.getId();
                result.add((Pair<Integer, Integer>)Pair.of((Object)oldId, (Object)newId));
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    static {
        CustomViaManager.initialize();
        for (ProtocolVersion version : ProtocolVersion.getProtocols()) {
            if (ProtocolVersion.getIndex(version) < ProtocolVersion.getIndex(ProtocolVersion.v1_7_1)) continue;
            EnumMap<State, PacketTypeRegistry> forState = new EnumMap<State, PacketTypeRegistry>(State.class);
            for (State state : State.values()) {
                forState.put(state, new PacketTypeRegistry(version, state));
            }
            forVersionAndState.put(version, forState);
        }
    }
}

