/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.pathing.interpolation;

import com.replaymod.replaystudio.pathing.interpolation.InterpolationParameters;
import com.replaymod.replaystudio.pathing.interpolation.PolynomialSplineInterpolator;

public class CubicSplineInterpolator
extends PolynomialSplineInterpolator {
    public CubicSplineInterpolator() {
        super(3);
    }

    @Override
    protected void fillMatrix(double[][] matrix, double[] xs, double[] ys, int num, InterpolationParameters params) {
        double x;
        int row = 0;
        if (params != null) {
            ys[0] = params.getValue();
            x = xs[0];
            matrix[row][0] = 3.0 * x * x;
            matrix[row][1] = 2.0 * x;
            matrix[row][2] = 1.0;
            matrix[row][num * 4] = params.getVelocity();
            matrix[++row][0] = 6.0 * x;
            matrix[row][1] = 2.0;
            matrix[row][num * 4] = params.getAcceleration();
            ++row;
        } else {
            matrix[row][0] = 6.0 * xs[0];
            matrix[row][1] = 2.0;
            matrix[++row][(num - 1) * 4] = 6.0 * xs[xs.length - 1];
            matrix[row][(num - 1) * 4 + 1] = 2.0;
            ++row;
        }
        for (int i = 0; i < num; ++i) {
            x = xs[i];
            matrix[row][i * 4] = x * x * x;
            matrix[row][i * 4 + 1] = x * x;
            matrix[row][i * 4 + 2] = x;
            matrix[row][i * 4 + 3] = 1.0;
            matrix[row][num * 4] = ys[i];
            x = xs[i + 1];
            matrix[++row][i * 4] = x * x * x;
            matrix[row][i * 4 + 1] = x * x;
            matrix[row][i * 4 + 2] = x;
            matrix[row][i * 4 + 3] = 1.0;
            matrix[row][num * 4] = ys[i + 1];
            ++row;
            if (i < num - 1) {
                x = xs[i + 1];
                double d = 3.0 * x * x;
                matrix[row][i * 4 + 4] = d;
                matrix[row][i * 4] = -d;
                double d2 = 2.0 * x;
                matrix[row][i * 4 + 5] = d2;
                matrix[row][i * 4 + 1] = -d2;
                matrix[row][i * 4 + 6] = 1.0;
                matrix[row][i * 4 + 2] = -1.0;
                ++row;
            }
            if (i >= num - 1) continue;
            x = xs[i + 1];
            double d = 6.0 * x;
            matrix[row][i * 4 + 4] = d;
            matrix[row][i * 4] = -d;
            matrix[row][i * 4 + 5] = 2.0;
            matrix[row][i * 4 + 1] = -2.0;
            ++row;
        }
    }
}

