/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.pathing.change;

import com.replaymod.replaystudio.lib.guava.base.Preconditions;
import com.replaymod.replaystudio.lib.guava.base.Predicates;
import com.replaymod.replaystudio.lib.guava.collect.Iterables;
import com.replaymod.replaystudio.pathing.change.Change;
import com.replaymod.replaystudio.pathing.interpolation.Interpolator;
import com.replaymod.replaystudio.pathing.path.Keyframe;
import com.replaymod.replaystudio.pathing.path.Path;
import com.replaymod.replaystudio.pathing.path.Timeline;
import lombok.NonNull;

public final class RemoveKeyframe
implements Change {
    private final int path;
    private final int index;
    private volatile Keyframe removedKeyframe;
    private volatile Interpolator removedInterpolator;
    private boolean applied;

    @NonNull
    public static RemoveKeyframe create(@NonNull Path path, @NonNull Keyframe keyframe) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        if (keyframe == null) {
            throw new NullPointerException("keyframe");
        }
        return new RemoveKeyframe(path.getTimeline().getPaths().indexOf(path), Iterables.indexOf(path.getKeyframes(), Predicates.equalTo(keyframe)));
    }

    RemoveKeyframe(int path, int index) {
        this.path = path;
        this.index = index;
    }

    @Override
    public void apply(Timeline timeline) {
        Preconditions.checkState(!this.applied, "Already applied!");
        Path path = timeline.getPaths().get(this.path);
        if (!path.getSegments().isEmpty()) {
            this.removedInterpolator = this.index == path.getSegments().size() ? Iterables.get(path.getSegments(), this.index - 1).getInterpolator() : Iterables.get(path.getSegments(), this.index).getInterpolator();
        }
        this.removedKeyframe = Iterables.get(path.getKeyframes(), this.index);
        path.remove(this.removedKeyframe, true);
        this.applied = true;
    }

    @Override
    public void undo(Timeline timeline) {
        Preconditions.checkState(this.applied, "Not yet applied!");
        Path path = timeline.getPaths().get(this.path);
        path.insert(this.removedKeyframe);
        if (this.removedInterpolator != null) {
            if (this.index == path.getSegments().size()) {
                Iterables.get(path.getSegments(), this.index - 1).setInterpolator(this.removedInterpolator);
            } else {
                Iterables.get(path.getSegments(), this.index).setInterpolator(this.removedInterpolator);
            }
        }
        this.applied = false;
    }
}

