/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.lib.viaversion.util;

import com.replaymod.replaystudio.lib.viaversion.libs.opennbt.tag.builtin.CompoundTag;
import com.replaymod.replaystudio.lib.viaversion.libs.opennbt.tag.builtin.ListTag;
import com.replaymod.replaystudio.lib.viaversion.libs.opennbt.tag.builtin.Tag;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class TagUtil {
    public static Tag handleDeep(Tag tag, TagUpdater consumer) {
        return TagUtil.handleDeep(null, tag, consumer);
    }

    private static Tag handleDeep(@Nullable String key, Tag tag, TagUpdater consumer) {
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            for (Map.Entry<String, Tag> entry : compoundTag.entrySet()) {
                Tag updatedTag = TagUtil.handleDeep(entry.getKey(), entry.getValue(), consumer);
                entry.setValue(updatedTag);
            }
        } else if (tag instanceof ListTag) {
            TagUtil.handleListTag((ListTag)tag, consumer);
        }
        return consumer.update(key, tag);
    }

    private static <T extends Tag> void handleListTag(ListTag<T> listTag, TagUpdater consumer) {
        listTag.getValue().replaceAll(t -> TagUtil.handleDeep(null, t, consumer));
    }

    @FunctionalInterface
    public static interface TagUpdater {
        public Tag update(@Nullable String var1, Tag var2);
    }
}

