/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.lib.viaversion.protocols.protocol1_9to1_8;

import com.replaymod.replaystudio.lib.viaversion.api.Via;
import com.replaymod.replaystudio.lib.viaversion.api.connection.UserConnection;
import com.replaymod.replaystudio.lib.viaversion.api.minecraft.ClientWorld;
import com.replaymod.replaystudio.lib.viaversion.api.minecraft.item.Item;
import com.replaymod.replaystudio.lib.viaversion.api.platform.providers.ViaProviders;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.AbstractProtocol;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.packet.PacketWrapper;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.packet.State;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.remapper.ValueTransformer;
import com.replaymod.replaystudio.lib.viaversion.api.type.Type;
import com.replaymod.replaystudio.lib.viaversion.libs.gson.JsonElement;
import com.replaymod.replaystudio.lib.viaversion.libs.gson.JsonObject;
import com.replaymod.replaystudio.lib.viaversion.protocols.protocol1_8.ClientboundPackets1_8;
import com.replaymod.replaystudio.lib.viaversion.protocols.protocol1_8.ServerboundPackets1_8;
import com.replaymod.replaystudio.lib.viaversion.protocols.protocol1_9to1_8.ClientboundPackets1_9;
import com.replaymod.replaystudio.lib.viaversion.protocols.protocol1_9to1_8.ServerboundPackets1_9;
import com.replaymod.replaystudio.lib.viaversion.protocols.protocol1_9to1_8.metadata.MetadataRewriter1_9To1_8;
import com.replaymod.replaystudio.lib.viaversion.protocols.protocol1_9to1_8.packets.EntityPackets;
import com.replaymod.replaystudio.lib.viaversion.protocols.protocol1_9to1_8.packets.InventoryPackets;
import com.replaymod.replaystudio.lib.viaversion.protocols.protocol1_9to1_8.packets.PlayerPackets;
import com.replaymod.replaystudio.lib.viaversion.protocols.protocol1_9to1_8.packets.SpawnPackets;
import com.replaymod.replaystudio.lib.viaversion.protocols.protocol1_9to1_8.packets.WorldPackets;
import com.replaymod.replaystudio.lib.viaversion.protocols.protocol1_9to1_8.providers.BossBarProvider;
import com.replaymod.replaystudio.lib.viaversion.protocols.protocol1_9to1_8.providers.CommandBlockProvider;
import com.replaymod.replaystudio.lib.viaversion.protocols.protocol1_9to1_8.providers.CompressionProvider;
import com.replaymod.replaystudio.lib.viaversion.protocols.protocol1_9to1_8.providers.EntityIdProvider;
import com.replaymod.replaystudio.lib.viaversion.protocols.protocol1_9to1_8.providers.HandItemProvider;
import com.replaymod.replaystudio.lib.viaversion.protocols.protocol1_9to1_8.providers.MainHandProvider;
import com.replaymod.replaystudio.lib.viaversion.protocols.protocol1_9to1_8.providers.MovementTransmitterProvider;
import com.replaymod.replaystudio.lib.viaversion.protocols.protocol1_9to1_8.storage.ClientChunks;
import com.replaymod.replaystudio.lib.viaversion.protocols.protocol1_9to1_8.storage.CommandBlockStorage;
import com.replaymod.replaystudio.lib.viaversion.protocols.protocol1_9to1_8.storage.EntityTracker1_9;
import com.replaymod.replaystudio.lib.viaversion.protocols.protocol1_9to1_8.storage.InventoryTracker;
import com.replaymod.replaystudio.lib.viaversion.protocols.protocol1_9to1_8.storage.MovementTracker;
import com.replaymod.replaystudio.lib.viaversion.util.GsonUtil;

public class Protocol1_9To1_8
extends AbstractProtocol<ClientboundPackets1_8, ClientboundPackets1_9, ServerboundPackets1_8, ServerboundPackets1_9> {
    public static final ValueTransformer<String, JsonElement> FIX_JSON = new ValueTransformer<String, JsonElement>(Type.COMPONENT){

        @Override
        public JsonElement transform(PacketWrapper wrapper, String line) {
            return Protocol1_9To1_8.fixJson(line);
        }
    };
    private final MetadataRewriter1_9To1_8 metadataRewriter = new MetadataRewriter1_9To1_8(this);

    public Protocol1_9To1_8() {
        super(ClientboundPackets1_8.class, ClientboundPackets1_9.class, ServerboundPackets1_8.class, ServerboundPackets1_9.class);
    }

    public static JsonElement fixJson(String line) {
        if (line == null || line.equalsIgnoreCase("null")) {
            line = "{\"text\":\"\"}";
        } else {
            if (!(line.startsWith("\"") && line.endsWith("\"") || line.startsWith("{") && line.endsWith("}"))) {
                return Protocol1_9To1_8.constructJson(line);
            }
            if (line.startsWith("\"") && line.endsWith("\"")) {
                line = "{\"text\":" + line + "}";
            }
        }
        try {
            return GsonUtil.getGson().fromJson(line, JsonObject.class);
        }
        catch (Exception e) {
            if (Via.getConfig().isForceJsonTransform()) {
                return Protocol1_9To1_8.constructJson(line);
            }
            Via.getPlatform().getLogger().warning("Invalid JSON String: \"" + line + "\" Please report this issue to the ViaVersion Github: " + e.getMessage());
            return GsonUtil.getGson().fromJson("{\"text\":\"\"}", JsonObject.class);
        }
    }

    private static JsonElement constructJson(String text) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("text", text);
        return jsonObject;
    }

    public static Item getHandItem(UserConnection info) {
        return Via.getManager().getProviders().get(HandItemProvider.class).getHandItem(info);
    }

    public static boolean isSword(int id) {
        switch (id) {
            case 267: 
            case 268: 
            case 272: 
            case 276: 
            case 283: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void registerPackets() {
        super.registerPackets();
        this.registerClientbound(State.LOGIN, 0, 0, (PacketWrapper wrapper) -> {
            if (wrapper.isReadable(Type.COMPONENT, 0)) {
                return;
            }
            wrapper.write(Type.COMPONENT, Protocol1_9To1_8.fixJson(wrapper.read(Type.STRING)));
        });
        SpawnPackets.register(this);
        InventoryPackets.register(this);
        EntityPackets.register(this);
        PlayerPackets.register(this);
        WorldPackets.register(this);
    }

    @Override
    public void register(ViaProviders providers) {
        providers.register(HandItemProvider.class, new HandItemProvider());
        providers.register(CommandBlockProvider.class, new CommandBlockProvider());
        providers.register(EntityIdProvider.class, new EntityIdProvider());
        providers.register(BossBarProvider.class, new BossBarProvider());
        providers.register(MainHandProvider.class, new MainHandProvider());
        providers.register(CompressionProvider.class, new CompressionProvider());
        providers.register(MovementTransmitterProvider.class, new MovementTransmitterProvider());
    }

    @Override
    public void init(UserConnection userConnection) {
        userConnection.addEntityTracker(this.getClass(), new EntityTracker1_9(userConnection));
        userConnection.put(new ClientChunks());
        userConnection.put(new MovementTracker());
        userConnection.put(new InventoryTracker());
        userConnection.put(new CommandBlockStorage());
        if (!userConnection.has(ClientWorld.class)) {
            userConnection.put(new ClientWorld());
        }
    }

    public MetadataRewriter1_9To1_8 getEntityRewriter() {
        return this.metadataRewriter;
    }
}

