/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.lib.viaversion.api.type.types.misc;

import com.github.steveice10.netty.buffer.ByteBuf;
import com.github.steveice10.netty.buffer.ByteBufInputStream;
import com.github.steveice10.netty.buffer.ByteBufOutputStream;
import com.replaymod.replaystudio.lib.viaversion.api.type.Type;
import com.replaymod.replaystudio.lib.viaversion.libs.opennbt.tag.builtin.CompoundTag;
import com.replaymod.replaystudio.lib.viaversion.libs.opennbt.tag.builtin.Tag;
import com.replaymod.replaystudio.lib.viaversion.libs.opennbt.tag.limiter.TagLimiter;
import java.io.IOException;
import org.checkerframework.checker.nullness.qual.Nullable;

public class NamedCompoundTagType
extends Type<CompoundTag> {
    public static final int MAX_NBT_BYTES = 0x200000;
    public static final int MAX_NESTING_LEVEL = 512;

    public NamedCompoundTagType() {
        super(CompoundTag.class);
    }

    @Override
    public CompoundTag read(ByteBuf buffer) throws IOException {
        return NamedCompoundTagType.read(buffer, true);
    }

    @Override
    public void write(ByteBuf buffer, CompoundTag object) throws IOException {
        NamedCompoundTagType.write(buffer, object, "");
    }

    public static CompoundTag read(ByteBuf buffer, boolean readName) throws IOException {
        byte id = buffer.readByte();
        if (id == 0) {
            return null;
        }
        if (id != 10) {
            throw new IOException(String.format("Expected root tag to be a CompoundTag, was %s", id));
        }
        if (readName) {
            buffer.skipBytes(buffer.readUnsignedShort());
        }
        TagLimiter tagLimiter = TagLimiter.create(0x200000, 512);
        return CompoundTag.read(new ByteBufInputStream(buffer), tagLimiter, 0);
    }

    public static void write(ByteBuf buffer, Tag tag, @Nullable String name) throws IOException {
        if (tag == null) {
            buffer.writeByte(0);
            return;
        }
        ByteBufOutputStream out = new ByteBufOutputStream(buffer);
        out.writeByte(tag.getTagId());
        if (name != null) {
            out.writeUTF(name);
        }
        tag.write(out);
    }
}

