/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.lib.viaversion.api.type.types;

import com.github.steveice10.netty.buffer.ByteBuf;
import com.replaymod.replaystudio.lib.viaversion.api.type.Type;

public class FixedByteArrayType
extends Type<byte[]> {
    private final int arrayLength;

    public FixedByteArrayType(int arrayLength) {
        super(byte[].class);
        this.arrayLength = arrayLength;
    }

    @Override
    public byte[] read(ByteBuf byteBuf) throws Exception {
        if (byteBuf.readableBytes() < this.arrayLength) {
            throw new RuntimeException("Readable bytes does not match expected!");
        }
        byte[] byteArray = new byte[this.arrayLength];
        byteBuf.readBytes(byteArray);
        return byteArray;
    }

    @Override
    public void write(ByteBuf byteBuf, byte[] bytes) throws Exception {
        byteBuf.writeBytes(bytes);
    }
}

