/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.lib.viaversion.api.type;

import com.github.steveice10.netty.buffer.ByteBuf;
import com.replaymod.replaystudio.lib.viaversion.api.type.Type;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class OptionalType<T>
extends Type<T> {
    private final Type<T> type;

    protected OptionalType(Type<T> type) {
        super(type.getOutputClass());
        this.type = type;
    }

    @Override
    public @Nullable T read(ByteBuf buffer) throws Exception {
        return buffer.readBoolean() ? (T)this.type.read(buffer) : null;
    }

    @Override
    public void write(ByteBuf buffer, @Nullable T value) throws Exception {
        if (value == null) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            this.type.write(buffer, value);
        }
    }
}

