/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.launcher;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.replaymod.replaystudio.PacketData;
import com.replaymod.replaystudio.Studio;
import com.replaymod.replaystudio.filter.StreamFilter;
import com.replaymod.replaystudio.io.ReplayOutputStream;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.packet.State;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.version.ProtocolVersion;
import com.replaymod.replaystudio.protocol.PacketTypeRegistry;
import com.replaymod.replaystudio.replay.ReplayMetaData;
import com.replaymod.replaystudio.replay.ZipReplayFile;
import com.replaymod.replaystudio.stream.PacketStream;
import com.replaymod.replaystudio.studio.ReplayStudio;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;

public class StreamLauncher {
    private final Studio studio = new ReplayStudio();

    public void launch(CommandLine cmd) throws IOException {
        ReplayOutputStream out;
        ArrayList<PacketStream.FilterInfo> filters = new ArrayList<PacketStream.FilterInfo>();
        String[] instructions = cmd.hasOption('q') ? new String[]{"squash"} : cmd.getOptionValue('s').split(",");
        for (String instruction : instructions) {
            JsonObject config;
            long end;
            long start;
            if (instruction.charAt(instruction.length() - 1) == ')') {
                int index = instruction.indexOf(40);
                String time = instruction.substring(index + 1, instruction.length() - 1);
                instruction = instruction.substring(0, index);
                start = this.timeStampToMillis(time.split("-", 2)[0]);
                end = this.timeStampToMillis(time.split("-", 2)[1]);
            } else {
                end = -1L;
                start = -1L;
            }
            if (instruction.charAt(instruction.length() - 1) == ']') {
                int index = instruction.indexOf(91);
                String str = instruction.substring(index + 1, instruction.length() - 1);
                instruction = instruction.substring(0, index);
                config = new JsonParser().parse("{" + str + "}").getAsJsonObject();
            } else {
                config = new JsonObject();
            }
            StreamFilter filter = this.studio.loadStreamFilter(instruction);
            if (filter == null) {
                throw new IllegalStateException("Filter not found: " + instruction);
            }
            filter.init(this.studio, config);
            filters.add(new PacketStream.FilterInfo(filter, start, end));
        }
        String input = cmd.getArgs()[0];
        String output = cmd.getArgs()[1];
        long start = System.nanoTime();
        System.out.println("Generating " + ("x".equals(output) ? 0 : 1) + " replay via 1 stream from 1 input applying " + filters.size() + " filter(s)");
        ZipReplayFile inFile = new ZipReplayFile(this.studio, new File(input));
        ReplayMetaData meta = inFile.getMetaData();
        ProtocolVersion inputVersion = meta.getProtocolVersion();
        if (!"x".equals(output)) {
            BufferedOutputStream buffOut = new BufferedOutputStream(new FileOutputStream(output));
            out = new ReplayOutputStream(inputVersion, buffOut, null);
        } else {
            out = null;
        }
        PacketStream stream = inFile.getPacketData(PacketTypeRegistry.get(inputVersion, State.LOGIN)).asPacketStream();
        stream.start();
        stream.addFilter(new ProgressFilter(meta.getDuration()));
        for (PacketStream.FilterInfo info : filters) {
            stream.addFilter(info.getFilter(), info.getFrom(), info.getTo());
        }
        System.out.println("Built pipeline: " + stream);
        if (out != null) {
            PacketData data;
            while ((data = stream.next()) != null) {
                out.write(data);
            }
            for (PacketData d : stream.end()) {
                out.write(d);
            }
            out.close();
        } else {
            while (stream.next() != null) {
            }
            stream.end();
        }
        System.in.close();
        System.out.println("Done after " + (System.nanoTime() - start) + "ns");
    }

    private long timeStampToMillis(String string) {
        if (string.length() == 0) {
            return -1L;
        }
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException e) {
            int msIndex;
            int sIndex;
            int mIndex;
            long time = 0L;
            int hIndex = string.indexOf(104);
            if (hIndex != -1) {
                time += (long)(3600000 * Integer.parseInt(string.substring(0, hIndex)));
                if (string.length() - 1 > hIndex) {
                    string = string.substring(hIndex + 1);
                }
            }
            if ((mIndex = string.indexOf(109)) != -1) {
                time += (long)(60000 * Integer.parseInt(string.substring(0, mIndex)));
                if (string.length() - 1 > mIndex) {
                    string = string.substring(mIndex + 1);
                }
            }
            if ((sIndex = string.indexOf(115)) != -1) {
                time += (long)(1000 * Integer.parseInt(string.substring(0, sIndex)));
                if (string.length() - 1 > sIndex) {
                    string = string.substring(sIndex + 1);
                }
            }
            if ((msIndex = string.indexOf("ms")) != -1) {
                time += (long)Integer.parseInt(string.substring(0, msIndex));
            }
            return time;
        }
    }

    private static class ProgressFilter
    implements StreamFilter {
        private final long total;
        private int lastUpdate;

        public ProgressFilter(long total) {
            this.total = total;
        }

        @Override
        public String getName() {
            return "progress";
        }

        @Override
        public void init(Studio studio, JsonObject config) {
        }

        @Override
        public void onStart(PacketStream stream) {
            this.lastUpdate = -1;
        }

        @Override
        public boolean onPacket(PacketStream stream, PacketData data) {
            int pct = (int)(data.getTime() * 100L / this.total);
            if (pct > this.lastUpdate) {
                this.lastUpdate = pct;
                System.out.print("Processing... " + pct + "%\r");
            }
            return true;
        }

        @Override
        public void onEnd(PacketStream stream, long timestamp) {
            System.out.println();
        }
    }
}

