/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replaystudio.filter;

import com.google.gson.JsonObject;
import com.replaymod.replaystudio.PacketData;
import com.replaymod.replaystudio.Studio;
import com.replaymod.replaystudio.filter.StreamFilter;
import com.replaymod.replaystudio.lib.guava.collect.Ordering;
import com.replaymod.replaystudio.protocol.PacketType;
import com.replaymod.replaystudio.stream.PacketStream;
import java.util.EnumMap;
import java.util.Map;
import org.apache.commons.lang3.mutable.MutableInt;

public class PacketCountFilter
implements StreamFilter {
    private final EnumMap<PacketType, MutableInt> count = new EnumMap(PacketType.class);

    @Override
    public String getName() {
        return "packet_count";
    }

    @Override
    public void init(Studio studio, JsonObject config) {
    }

    @Override
    public void onStart(PacketStream stream) {
        this.count.clear();
    }

    @Override
    public boolean onPacket(PacketStream stream, PacketData data) {
        PacketType type = data.getPacket().getType();
        this.count.computeIfAbsent(type, key -> new MutableInt()).increment();
        return true;
    }

    @Override
    public void onEnd(PacketStream stream, long timestamp) {
        System.out.println();
        System.out.println();
        Ordering entryOrdering = Ordering.natural().reverse().onResultOf(Map.Entry::getValue);
        for (Map.Entry entry : entryOrdering.immutableSortedCopy(this.count.entrySet())) {
            System.out.println(String.format("[%dx] %s", ((MutableInt)entry.getValue()).intValue(), ((PacketType)((Object)entry.getKey())).toString()));
        }
        System.out.println();
    }
}

