/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replay.gui.overlay;

import com.replaymod.core.ReplayMod;
import com.replaymod.core.events.KeyBindingEventCallback;
import com.replaymod.core.events.KeyEventCallback;
import com.replaymod.replay.ReplayHandler;
import com.replaymod.replay.ReplayModReplay;
import com.replaymod.replay.ReplaySender;
import com.replaymod.replay.gui.overlay.GuiMarkerTimeline;
import de.johni0702.minecraft.gui.GuiRenderer;
import de.johni0702.minecraft.gui.RenderInfo;
import de.johni0702.minecraft.gui.container.AbstractGuiOverlay;
import de.johni0702.minecraft.gui.container.GuiPanel;
import de.johni0702.minecraft.gui.element.GuiButton;
import de.johni0702.minecraft.gui.element.GuiElement;
import de.johni0702.minecraft.gui.element.GuiSlider;
import de.johni0702.minecraft.gui.element.GuiTooltip;
import de.johni0702.minecraft.gui.element.advanced.IGuiTimeline;
import de.johni0702.minecraft.gui.layout.CustomLayout;
import de.johni0702.minecraft.gui.layout.HorizontalLayout;
import de.johni0702.minecraft.gui.utils.EventRegistrations;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadableDimension;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadablePoint;
import de.johni0702.minecraft.gui.utils.lwjgl.WritablePoint;
import net.minecraft.client.Options;
import net.minecraft.client.resources.language.I18n;

public class GuiReplayOverlay
extends AbstractGuiOverlay<GuiReplayOverlay> {
    private final ReplayModReplay mod = ReplayModReplay.instance;
    public final GuiPanel topPanel = (GuiPanel)new GuiPanel(this).setLayout(new HorizontalLayout(HorizontalLayout.Alignment.LEFT).setSpacing(5));
    public final GuiButton playPauseButton = (GuiButton)((GuiButton)((GuiButton)new GuiButton(){

        @Override
        public GuiElement getTooltip(RenderInfo renderInfo) {
            GuiTooltip tooltip = (GuiTooltip)super.getTooltip(renderInfo);
            if (tooltip != null) {
                String label = this.getSpriteUV().getY() == 0 ? "replaymod.gui.ingame.menu.unpause" : "replaymod.gui.ingame.menu.pause";
                tooltip.setText(I18n.m_118938_((String)label, (Object[])new Object[0]) + " (" + GuiReplayOverlay.this.mod.keyPlayPause.getBoundKey() + ")");
            }
            return tooltip;
        }
    }.setSize(20, 20)).setTexture(ReplayMod.TEXTURE, 256)).setTooltip(new GuiTooltip());
    public final GuiSlider speedSlider = (GuiSlider)((GuiSlider)new GuiSlider().setSize(100, 20)).setSteps(37);
    public final GuiMarkerTimeline timeline;
    public final GuiPanel statusIndicatorPanel = (GuiPanel)((GuiPanel)new GuiPanel(this).setSize(100, 16)).setLayout(new HorizontalLayout(HorizontalLayout.Alignment.RIGHT).setSpacing(5));
    private final EventHandler eventHandler = new EventHandler();
    private boolean hidden;

    public GuiReplayOverlay(final ReplayHandler replayHandler) {
        this.timeline = (GuiMarkerTimeline)new GuiMarkerTimeline(replayHandler){

            @Override
            public void draw(GuiRenderer renderer, ReadableDimension size, RenderInfo renderInfo) {
                this.setCursorPosition(replayHandler.getReplaySender().currentTimeStamp());
                super.draw(renderer, size, renderInfo);
            }
        }.setSize(Integer.MAX_VALUE, 20);
        this.topPanel.addElements(null, new GuiElement[]{this.playPauseButton, this.speedSlider, this.timeline});
        this.setLayout(new CustomLayout<GuiReplayOverlay>(){

            @Override
            protected void layout(GuiReplayOverlay container, int width, int height) {
                this.pos(GuiReplayOverlay.this.topPanel, 10, 10);
                this.size(GuiReplayOverlay.this.topPanel, width - 20, 20);
                this.pos(GuiReplayOverlay.this.statusIndicatorPanel, width / 2, height - 21);
                this.width(GuiReplayOverlay.this.statusIndicatorPanel, width / 2 - 5);
            }
        });
        ((GuiButton)this.playPauseButton.setSpriteUV(new ReadablePoint(){

            public int getX() {
                return 0;
            }

            public int getY() {
                return replayHandler.getReplaySender().paused() ? 0 : 20;
            }

            public void getLocation(WritablePoint dest) {
                dest.setLocation(this.getX(), this.getY());
            }
        })).onClick(new Runnable(){

            @Override
            public void run() {
                ReplaySender replaySender = replayHandler.getReplaySender();
                if (replaySender.paused()) {
                    replaySender.setReplaySpeed(GuiReplayOverlay.this.getSpeedSliderValue());
                } else {
                    replaySender.setReplaySpeed(0.0);
                }
            }
        });
        ((GuiSlider)this.speedSlider.onValueChanged(new Runnable(){

            @Override
            public void run() {
                double speed = GuiReplayOverlay.this.getSpeedSliderValue();
                GuiReplayOverlay.this.speedSlider.setText(I18n.m_118938_((String)"replaymod.gui.speed", (Object[])new Object[0]) + ": " + speed + "x");
                ReplaySender replaySender = replayHandler.getReplaySender();
                if (!replaySender.paused()) {
                    replaySender.setReplaySpeed(speed);
                }
            }
        })).setValue(9);
        ((GuiMarkerTimeline)this.timeline.onClick(new IGuiTimeline.OnClick(){

            @Override
            public void run(int time) {
                replayHandler.doJump(time, true);
            }
        })).setLength(replayHandler.getReplayDuration());
    }

    public double getSpeedSliderValue() {
        int value = this.speedSlider.getValue() + 1;
        if (value <= 9) {
            return (double)value / 10.0;
        }
        return 1.0 + 0.25 * (double)(value - 10);
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.isVisible() != visible) {
            if (visible) {
                this.eventHandler.register();
            } else {
                this.eventHandler.unregister();
            }
        }
        super.setVisible(visible);
    }

    @Override
    public void draw(GuiRenderer renderer, ReadableDimension size, RenderInfo renderInfo) {
        if ((this.getMinecraft().f_91066_.f_92062_ || this.hidden) && this.isAllowUserInput()) {
            return;
        }
        super.draw(renderer, size, renderInfo);
    }

    @Override
    protected GuiReplayOverlay getThis() {
        return this;
    }

    private class EventHandler
    extends EventRegistrations {
        private EventHandler() {
            this.on(KeyBindingEventCallback.EVENT, this::onKeyBindingEvent);
            this.on(KeyEventCallback.EVENT, (key, scanCode, action, modifiers) -> {
                this.onKeyInput(key, action);
                return false;
            });
        }

        private void onKeyBindingEvent() {
            Options gameSettings = GuiReplayOverlay.this.getMinecraft().f_91066_;
            while (gameSettings.f_92098_.m_90859_() || gameSettings.f_92100_.m_90859_()) {
                if (GuiReplayOverlay.this.isMouseVisible()) continue;
                GuiReplayOverlay.this.setMouseVisible(true);
            }
        }

        private void onKeyInput(int key, int action) {
            if (action != 1) {
                return;
            }
            if (GuiReplayOverlay.this.isMouseVisible() && key == 290) {
                GuiReplayOverlay.this.hidden = !GuiReplayOverlay.this.hidden;
            }
        }
    }
}

