/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replay.camera;

import com.replaymod.core.KeyBindingRegistry;
import com.replaymod.core.ReplayMod;
import com.replaymod.core.SettingsRegistry;
import com.replaymod.core.events.KeyBindingEventCallback;
import com.replaymod.core.events.PreRenderCallback;
import com.replaymod.core.events.PreRenderHandCallback;
import com.replaymod.core.events.SettingsChangedCallback;
import com.replaymod.core.utils.Utils;
import com.replaymod.core.versions.MCVer;
import com.replaymod.replay.ReplayHandler;
import com.replaymod.replay.ReplayModReplay;
import com.replaymod.replay.Setting;
import com.replaymod.replay.camera.CameraController;
import com.replaymod.replay.camera.SpectatorCameraController;
import com.replaymod.replay.events.RenderHotbarCallback;
import com.replaymod.replay.events.RenderSpectatorCrosshairCallback;
import com.replaymod.replay.mixin.EntityPlayerAccessor;
import com.replaymod.replay.mixin.FirstPersonRendererAccessor;
import com.replaymod.replaystudio.util.Location;
import de.johni0702.minecraft.gui.utils.EventRegistrations;
import de.johni0702.minecraft.gui.versions.callbacks.PreTickCallback;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.client.ClientRecipeBook;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.StatsCounter;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class CameraEntity
extends LocalPlayer {
    private static final UUID CAMERA_UUID = UUID.nameUUIDFromBytes("ReplayModCamera".getBytes(StandardCharsets.UTF_8));
    public float roll;
    private CameraController cameraController;
    private long lastControllerUpdate = System.currentTimeMillis();
    private Entity lastHandRendered = null;
    private EventHandler eventHandler = new EventHandler();
    private final Inventory originalInventory = this.m_150109_();

    public CameraEntity(Minecraft mcIn, ClientLevel worldIn, ClientPacketListener netHandlerPlayClient, StatsCounter statisticsManager, ClientRecipeBook recipeBook) {
        super(mcIn, worldIn, netHandlerPlayClient, statisticsManager, recipeBook, false, false);
        this.m_20084_(CAMERA_UUID);
        this.eventHandler.register();
        this.cameraController = ReplayModReplay.instance.getReplayHandler().getSpectatedUUID() == null ? ReplayModReplay.instance.createCameraController(this) : new SpectatorCameraController(this);
    }

    public CameraController getCameraController() {
        return this.cameraController;
    }

    public void setCameraController(CameraController cameraController) {
        this.cameraController = cameraController;
    }

    public void moveCamera(double x, double y, double z) {
        this.setCameraPosition(this.m_20185_() + x, this.m_20186_() + y, this.m_20189_() + z);
    }

    public void setCameraPosition(double x, double y, double z) {
        this.f_19790_ = this.f_19854_ = x;
        this.f_19791_ = this.f_19855_ = y;
        this.f_19792_ = this.f_19856_ = z;
        this.m_20343_(x, y, z);
        this.updateBoundingBox();
    }

    public void setCameraRotation(float yaw, float pitch, float roll) {
        this.f_19859_ = yaw;
        this.f_19860_ = pitch;
        this.m_146922_(yaw);
        this.m_146926_(pitch);
        this.roll = roll;
    }

    public void setCameraPosRot(Location pos) {
        this.setCameraRotation(pos.getYaw(), pos.getPitch(), this.roll);
        this.setCameraPosition(pos.getX(), pos.getY(), pos.getZ());
    }

    public void setCameraPosRot(Entity to) {
        if (to == this) {
            return;
        }
        float yOffset = 0.0f;
        this.f_19854_ = to.f_19854_;
        this.f_19855_ = to.f_19855_ + (double)yOffset;
        this.f_19856_ = to.f_19856_;
        this.f_19859_ = to.f_19859_;
        this.f_19860_ = to.f_19860_;
        this.m_20343_(to.m_20185_(), to.m_20186_(), to.m_20189_());
        this.m_146922_(to.m_146908_());
        this.m_146926_(to.m_146909_());
        this.f_19790_ = to.f_19790_;
        this.f_19791_ = to.f_19791_ + (double)yOffset;
        this.f_19792_ = to.f_19792_;
        this.wrapArmYaw();
        this.updateBoundingBox();
    }

    public float m_5675_(float tickDelta) {
        Entity view = this.f_108619_.m_91288_();
        if (view != null && view != this) {
            return this.f_19859_ + (this.m_146908_() - this.f_19859_) * tickDelta;
        }
        return super.m_5675_(tickDelta);
    }

    public float m_5686_(float tickDelta) {
        Entity view = this.f_108619_.m_91288_();
        if (view != null && view != this) {
            return this.f_19860_ + (this.m_146909_() - this.f_19860_) * tickDelta;
        }
        return super.m_5686_(tickDelta);
    }

    private void updateBoundingBox() {
        float width = this.m_20205_();
        float height = this.m_20206_();
        this.m_20011_(new AABB(this.m_20185_() - (double)(width / 2.0f), this.m_20186_(), this.m_20189_() - (double)(width / 2.0f), this.m_20185_() + (double)(width / 2.0f), this.m_20186_() + (double)height, this.m_20189_() + (double)(width / 2.0f)));
    }

    public void m_8119_() {
        Entity view = this.f_108619_.m_91288_();
        if (view != null) {
            UUID spectating = ReplayModReplay.instance.getReplayHandler().getSpectatedUUID();
            if (spectating != null && (view.m_20148_() != spectating || view.m_9236_() != this.m_9236_()) || this.m_9236_().m_6815_(view.m_19879_()) != view) {
                if (spectating == null) {
                    ReplayModReplay.instance.getReplayHandler().spectateEntity((Entity)this);
                    return;
                }
                view = this.m_9236_().m_46003_(spectating);
                if (view != null) {
                    this.f_108619_.m_91118_(view);
                } else {
                    this.f_108619_.m_91118_((Entity)this);
                    return;
                }
            }
            if (view != this) {
                this.setCameraPosRot(view);
            }
        }
    }

    public void m_172530_() {
        if (this.f_108619_.f_91073_ != null) {
            this.m_284535_((Level)this.f_108619_.f_91073_);
        }
        super.m_172530_();
    }

    public void m_19915_(float yaw, float pitch) {
        if (this.f_108619_.m_91288_() == this) {
            super.m_19915_(yaw, pitch);
        }
    }

    public boolean m_5830_() {
        return this.falseUnlessSpectating(Entity::m_5830_);
    }

    public boolean m_204029_(TagKey<Fluid> fluid) {
        return this.falseUnlessSpectating(entity -> entity.m_204029_(fluid));
    }

    public float m_108639_() {
        return this.falseUnlessSpectating(__ -> true) ? super.m_108639_() : 1.0f;
    }

    public boolean m_6060_() {
        return this.falseUnlessSpectating(Entity::m_6060_);
    }

    private boolean falseUnlessSpectating(Function<Entity, Boolean> property) {
        Entity view = this.f_108619_.m_91288_();
        if (view != null && view != this) {
            return property.apply(view);
        }
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_20076_() {
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_5833_() {
        ReplayHandler replayHandler = ReplayModReplay.instance.getReplayHandler();
        return replayHandler == null || replayHandler.isCameraView();
    }

    public boolean m_6000_(double double_1, double double_2, double double_3) {
        return false;
    }

    public float m_108565_() {
        Entity view = this.f_108619_.m_91288_();
        if (view != this && view instanceof AbstractClientPlayer) {
            return ((AbstractClientPlayer)view).m_108565_();
        }
        return 1.0f;
    }

    public boolean m_20145_() {
        Entity view = this.f_108619_.m_91288_();
        if (view != this) {
            return view.m_20145_();
        }
        return super.m_20145_();
    }

    public ResourceLocation m_108560_() {
        Entity view = this.f_108619_.m_91288_();
        if (view != this && view instanceof AbstractClientPlayer) {
            return ((AbstractClientPlayer)view).m_108560_();
        }
        return super.m_108560_();
    }

    public boolean m_36170_(PlayerModelPart modelPart) {
        Entity view = this.f_108619_.m_91288_();
        if (view != this && view instanceof Player) {
            return ((Player)view).m_36170_(modelPart);
        }
        return super.m_36170_(modelPart);
    }

    public HumanoidArm m_5737_() {
        Entity view = this.f_108619_.m_91288_();
        if (view != this && view instanceof Player) {
            return ((Player)view).m_5737_();
        }
        return super.m_5737_();
    }

    public float m_21324_(float renderPartialTicks) {
        Entity view = this.f_108619_.m_91288_();
        if (view != this && view instanceof Player) {
            return ((Player)view).m_21324_(renderPartialTicks);
        }
        return 0.0f;
    }

    public float m_36333_() {
        Entity view = this.f_108619_.m_91288_();
        if (view != this && view instanceof Player) {
            return ((Player)view).m_36333_();
        }
        return 1.0f;
    }

    public float m_36403_(float adjustTicks) {
        Entity view = this.f_108619_.m_91288_();
        if (view != this && view instanceof Player) {
            return ((Player)view).m_36403_(adjustTicks);
        }
        return 1.0f;
    }

    public InteractionHand m_7655_() {
        Entity view = this.f_108619_.m_91288_();
        if (view != this && view instanceof Player) {
            return ((Player)view).m_7655_();
        }
        return super.m_7655_();
    }

    public boolean m_6117_() {
        Entity view = this.f_108619_.m_91288_();
        if (view != this && view instanceof Player) {
            return ((Player)view).m_6117_();
        }
        return super.m_6117_();
    }

    public void m_238392_(EquipmentSlot slot, ItemStack stack, ItemStack itemStack) {
    }

    public HitResult m_19907_(double maxDistance, float tickDelta, boolean fluids) {
        HitResult result = super.m_19907_(maxDistance, tickDelta, fluids);
        if (result instanceof BlockHitResult) {
            BlockHitResult blockResult = (BlockHitResult)result;
            result = BlockHitResult.m_82426_((Vec3)result.m_82450_(), (Direction)blockResult.m_82434_(), (BlockPos)blockResult.m_82425_());
        }
        return result;
    }

    public void m_142687_(Entity.RemovalReason reason) {
        super.m_142687_(reason);
        if (this.eventHandler != null) {
            this.eventHandler.unregister();
            this.eventHandler = null;
        }
    }

    private void update() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != this.m_9236_()) {
            if (this.eventHandler != null) {
                this.eventHandler.unregister();
                this.eventHandler = null;
            }
            return;
        }
        long now = System.currentTimeMillis();
        long timePassed = now - this.lastControllerUpdate;
        this.cameraController.update((float)timePassed / 50.0f);
        this.lastControllerUpdate = now;
        this.handleInputEvents();
        Map<String, KeyBindingRegistry.Binding> keyBindings = ReplayMod.instance.getKeyBindingRegistry().getBindings();
        if (keyBindings.get((Object)"replaymod.input.rollclockwise").keyBinding.m_90857_()) {
            this.roll = (float)((double)this.roll + (Utils.isCtrlDown() ? 0.2 : 1.0));
        }
        if (keyBindings.get((Object)"replaymod.input.rollcounterclockwise").keyBinding.m_90857_()) {
            this.roll = (float)((double)this.roll - (Utils.isCtrlDown() ? 0.2 : 1.0));
        }
        this.f_19794_ = this.m_5833_();
        this.syncInventory();
    }

    private void syncInventory() {
        Entity view = this.f_108619_.m_91288_();
        Player viewPlayer = view != this && view instanceof Player ? (Player)view : null;
        EntityPlayerAccessor cameraA = (EntityPlayerAccessor)((Object)this);
        EntityPlayerAccessor viewPlayerA = (EntityPlayerAccessor)viewPlayer;
        ItemStack empty = ItemStack.f_41583_;
        this.m_8061_(EquipmentSlot.HEAD, viewPlayer != null ? viewPlayer.m_6844_(EquipmentSlot.HEAD) : empty);
        this.m_8061_(EquipmentSlot.MAINHAND, viewPlayer != null ? viewPlayer.m_6844_(EquipmentSlot.MAINHAND) : empty);
        this.m_8061_(EquipmentSlot.OFFHAND, viewPlayer != null ? viewPlayer.m_6844_(EquipmentSlot.OFFHAND) : empty);
        cameraA.setItemStackMainHand(viewPlayerA != null ? viewPlayerA.getItemStackMainHand() : empty);
        this.f_20912_ = viewPlayer != null ? viewPlayer.f_20912_ : InteractionHand.MAIN_HAND;
        this.f_20935_ = viewPlayer != null ? viewPlayer.m_21211_() : empty;
        cameraA.setActiveItemStackUseCount(viewPlayerA != null ? viewPlayerA.getActiveItemStackUseCount() : 0);
    }

    private void handleInputEvents() {
        if ((this.f_108619_.f_91066_.f_92096_.m_90859_() || this.f_108619_.f_91066_.f_92095_.m_90859_()) && this.f_108619_.f_91080_ == null && this.canSpectate(this.f_108619_.f_91076_)) {
            ReplayModReplay.instance.getReplayHandler().spectateEntity(this.f_108619_.f_91076_);
            while (this.f_108619_.f_91066_.f_92090_.m_90859_()) {
            }
        }
    }

    private void updateArmYawAndPitch() {
        this.f_108587_ = this.f_108585_;
        this.f_108588_ = this.f_108586_;
        this.f_108586_ += (this.m_146909_() - this.f_108586_) * 0.5f;
        this.f_108585_ += CameraEntity.wrapDegrees(this.m_146908_() - this.f_108585_) * 0.5f;
        this.wrapArmYaw();
    }

    private void wrapArmYaw() {
        this.f_108585_ = CameraEntity.wrapDegreesTo(this.f_108585_, this.m_146908_());
        this.f_108587_ = CameraEntity.wrapDegreesTo(this.f_108587_, this.f_108585_);
    }

    private static float wrapDegreesTo(float value, float towardsValue) {
        while (towardsValue - value < -180.0f) {
            value -= 360.0f;
        }
        while (towardsValue - value >= 180.0f) {
            value += 360.0f;
        }
        return value;
    }

    private static float wrapDegrees(float value) {
        return CameraEntity.wrapDegreesTo(value %= 360.0f, 0.0f);
    }

    public boolean canSpectate(Entity e) {
        return e != null && !e.m_20145_();
    }

    private class EventHandler
    extends EventRegistrations {
        private final Minecraft mc = MCVer.getMinecraft();
        private boolean heldItemTooltipsWasTrue;

        private EventHandler() {
            this.on(PreTickCallback.EVENT, this::onPreClientTick);
            this.on(PreRenderCallback.EVENT, this::onRenderUpdate);
            this.on(KeyBindingEventCallback.EVENT, CameraEntity.this::handleInputEvents);
            this.on(RenderSpectatorCrosshairCallback.EVENT, this::shouldRenderSpectatorCrosshair);
            this.on(RenderHotbarCallback.EVENT, this::shouldRenderHotbar);
            this.on(SettingsChangedCallback.EVENT, this::onSettingsChanged);
            this.on(PreRenderHandCallback.EVENT, this::onRenderHand);
        }

        private void onPreClientTick() {
            CameraEntity.this.updateArmYawAndPitch();
        }

        private void onRenderUpdate() {
            CameraEntity.this.update();
        }

        private Boolean shouldRenderSpectatorCrosshair() {
            return CameraEntity.this.canSpectate(this.mc.f_91076_);
        }

        private Boolean shouldRenderHotbar() {
            return false;
        }

        private void onSettingsChanged(SettingsRegistry registry, SettingsRegistry.SettingKey<?> key) {
            if (key == Setting.CAMERA) {
                CameraEntity.this.cameraController = ReplayModReplay.instance.getReplayHandler().getSpectatedUUID() == null ? ReplayModReplay.instance.createCameraController(CameraEntity.this) : new SpectatorCameraController(CameraEntity.this);
            }
        }

        private boolean onRenderHand() {
            Entity view = this.mc.m_91288_();
            if (view == CameraEntity.this || !(view instanceof Player)) {
                return true;
            }
            Player player = (Player)view;
            if (CameraEntity.this.lastHandRendered != player) {
                CameraEntity.this.lastHandRendered = player;
                FirstPersonRendererAccessor acc = (FirstPersonRendererAccessor)this.mc.f_91063_.f_109055_;
                acc.setPrevEquippedProgressMainHand(1.0f);
                acc.setPrevEquippedProgressOffHand(1.0f);
                acc.setEquippedProgressMainHand(1.0f);
                acc.setEquippedProgressOffHand(1.0f);
                acc.setItemStackMainHand(player.m_6844_(EquipmentSlot.MAINHAND));
                acc.setItemStackOffHand(player.m_6844_(EquipmentSlot.OFFHAND));
                this.mc.f_91074_.f_108585_ = this.mc.f_91074_.f_108587_ = player.m_146908_();
                this.mc.f_91074_.f_108586_ = this.mc.f_91074_.f_108588_ = player.m_146909_();
            }
            return false;
        }
    }
}

