/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replay;

import com.replaymod.core.SettingsRegistry;
import com.replaymod.replay.handler.GuiHandler;
import java.util.Arrays;
import java.util.stream.Collectors;

public final class Setting<T>
extends SettingsRegistry.SettingKeys<T> {
    public static final Setting<Boolean> SHOW_CHAT = Setting.make("showChat", "showchat", true);
    public static final Setting<Boolean> SHOW_SERVER_IPS = new Setting<Boolean>("showServerIPs", true);
    public static final SettingsRegistry.MultipleChoiceSettingKeys<String> CAMERA = new SettingsRegistry.MultipleChoiceSettingKeys<String>("replay", "camera", "replaymod.gui.settings.camera", "replaymod.camera.classic");
    public static final Setting<Boolean> LEGACY_MAIN_MENU_BUTTON = new Setting<Boolean>("legacyMainMenuButton", false);
    public static final SettingsRegistry.MultipleChoiceSettingKeys<String> MAIN_MENU_BUTTON = new SettingsRegistry.MultipleChoiceSettingKeys<String>("replay", "mainMenuButton", null, GuiHandler.MainMenuButtonPosition.DEFAULT.name());

    private static <T> Setting<T> make(String key, String displayName, T defaultValue) {
        return new Setting<T>(key, displayName, defaultValue);
    }

    public Setting(String key, String displayString, T defaultValue) {
        super("replay", key, "replaymod.gui.settings." + displayString, defaultValue);
    }

    public Setting(String key, T defaultValue) {
        super("replay", key, null, defaultValue);
    }

    static {
        MAIN_MENU_BUTTON.setChoices(Arrays.stream(GuiHandler.MainMenuButtonPosition.values()).map(Enum::name).collect(Collectors.toList()));
    }
}

