/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.replay;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexSorting;
import com.replaymod.core.ReplayMod;
import com.replaymod.core.mixin.MinecraftAccessor;
import com.replaymod.core.mixin.TimerAccessor;
import com.replaymod.core.utils.Restrictions;
import com.replaymod.core.utils.Utils;
import com.replaymod.core.versions.MCVer;
import com.replaymod.replay.FullReplaySender;
import com.replaymod.replay.QuickReplaySender;
import com.replaymod.replay.ReplayModReplay;
import com.replaymod.replay.ReplaySender;
import com.replaymod.replay.camera.CameraEntity;
import com.replaymod.replay.camera.SpectatorCameraController;
import com.replaymod.replay.events.ReplayClosedCallback;
import com.replaymod.replay.events.ReplayClosingCallback;
import com.replaymod.replay.events.ReplayOpenedCallback;
import com.replaymod.replay.gui.overlay.GuiReplayOverlay;
import com.replaymod.replay.mixin.EntityLivingBaseAccessor;
import com.replaymod.replaystudio.data.Marker;
import com.replaymod.replaystudio.replay.ReplayFile;
import com.replaymod.replaystudio.util.Location;
import de.johni0702.minecraft.gui.container.AbstractGuiScreen;
import de.johni0702.minecraft.gui.container.GuiContainer;
import de.johni0702.minecraft.gui.container.GuiScreen;
import de.johni0702.minecraft.gui.element.GuiElement;
import de.johni0702.minecraft.gui.element.GuiLabel;
import de.johni0702.minecraft.gui.element.advanced.GuiProgressBar;
import de.johni0702.minecraft.gui.layout.HorizontalLayout;
import de.johni0702.minecraft.gui.popup.AbstractGuiPopup;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.embedded.EmbeddedChannel;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ReceivingLevelScreen;
import net.minecraft.client.multiplayer.ClientHandshakePacketListenerImpl;
import net.minecraft.network.Connection;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.PacketBundlePacker;
import net.minecraft.network.PacketListener;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkHooks;
import org.joml.Matrix4f;

public class ReplayHandler {
    private static Minecraft mc = MCVer.getMinecraft();
    private final ReplayFile replayFile;
    private final FullReplaySender fullReplaySender;
    private final QuickReplaySender quickReplaySender;
    private boolean quickMode = false;
    private Restrictions restrictions = new Restrictions();
    private boolean suppressCameraMovements;
    private Set<Marker> markers;
    private final GuiReplayOverlay overlay;
    private EmbeddedChannel channel;
    private int replayDuration;
    private Location targetCameraPosition;
    private UUID spectating;

    public ReplayHandler(ReplayFile replayFile, boolean asyncMode) throws IOException {
        Preconditions.checkState((boolean)mc.m_18695_(), (Object)"Must be called from Minecraft thread.");
        this.replayFile = replayFile;
        this.replayDuration = replayFile.getMetaData().getDuration();
        this.markers = replayFile.getMarkers().or(Collections.emptySet());
        this.fullReplaySender = new FullReplaySender(this, replayFile, false);
        this.quickReplaySender = new QuickReplaySender(ReplayModReplay.instance, replayFile);
        this.setup();
        this.overlay = new GuiReplayOverlay(this);
        this.overlay.setVisible(true);
        ReplayOpenedCallback.EVENT.invoker().replayOpened(this);
        this.fullReplaySender.setAsyncMode(asyncMode);
    }

    void restartedReplay() {
        Preconditions.checkState((boolean)mc.m_18695_(), (Object)"Must be called from Minecraft thread.");
        this.channel.close();
        ReplayHandler.mc.f_91067_.m_91602_();
        mc.m_91399_();
        this.restrictions = new Restrictions();
        this.setup();
    }

    public void endReplay() throws IOException {
        Preconditions.checkState((boolean)mc.m_18695_(), (Object)"Must be called from Minecraft thread.");
        ReplayClosingCallback.EVENT.invoker().replayClosing(this);
        this.fullReplaySender.terminateReplay();
        if (this.quickMode) {
            this.quickReplaySender.unregister();
        }
        this.replayFile.save();
        this.replayFile.close();
        this.channel.close().awaitUninterruptibly();
        if (ReplayHandler.mc.f_91074_ instanceof CameraEntity) {
            // empty if block
        }
        if (ReplayHandler.mc.f_91073_ != null) {
            mc.m_91399_();
        }
        TimerAccessor timer = (TimerAccessor)((MinecraftAccessor)mc).getTimer();
        timer.setTickLength(50.0f);
        this.overlay.setVisible(false);
        ReplayModReplay.instance.forcefullyStopReplay();
        mc.m_91152_(null);
        ReplayClosedCallback.EVENT.invoker().replayClosed(this);
    }

    private void setup() {
        Preconditions.checkState((boolean)mc.m_18695_(), (Object)"Must be called from Minecraft thread.");
        ReplayHandler.mc.f_91065_.m_93076_().m_93795_(false);
        Connection networkManager = new Connection(PacketFlow.CLIENTBOUND){

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable t) {
                t.printStackTrace();
            }
        };
        this.channel = new EmbeddedChannel();
        this.channel.pipeline().addLast("ReplayModReplay_quickReplaySender", (ChannelHandler)this.quickReplaySender);
        this.channel.pipeline().addLast("ReplayModReplay_replaySender", (ChannelHandler)this.fullReplaySender);
        this.channel.pipeline().addLast("bundler", (ChannelHandler)new PacketBundlePacker(PacketFlow.CLIENTBOUND));
        this.channel.pipeline().addLast("packet_handler", (ChannelHandler)networkManager);
        this.channel.pipeline().fireChannelActive();
        NetworkHooks.registerClientLoginChannel((Connection)networkManager);
        networkManager.m_129498_(ConnectionProtocol.LOGIN);
        networkManager.m_129505_((PacketListener)new ClientHandshakePacketListenerImpl(networkManager, mc, null, null, false, null, it -> {}));
        ((MinecraftAccessor)mc).setConnection(networkManager);
    }

    public ReplayFile getReplayFile() {
        return this.replayFile;
    }

    public Restrictions getRestrictions() {
        return this.restrictions;
    }

    public ReplaySender getReplaySender() {
        return this.quickMode ? this.quickReplaySender : this.fullReplaySender;
    }

    public GuiReplayOverlay getOverlay() {
        return this.overlay;
    }

    public void ensureQuickModeInitialized(final Runnable andThen) {
        if (Utils.ifMinimalModeDoPopup(this.overlay, () -> {})) {
            return;
        }
        ListenableFuture<Void> future = this.quickReplaySender.getInitializationPromise();
        if (future == null) {
            final InitializingQuickModePopup popup = new InitializingQuickModePopup(this.overlay);
            future = this.quickReplaySender.initialize(progress -> popup.progressBar.setProgress(progress.floatValue()));
            Futures.addCallback(future, (FutureCallback)new FutureCallback<Void>(){

                public void onSuccess(@Nullable Void result) {
                    popup.close();
                }

                public void onFailure(@Nonnull Throwable t) {
                    String message = "Failed to initialize quick mode. It will not be available.";
                    Utils.error(ReplayModReplay.LOGGER, ReplayHandler.this.overlay, CrashReport.m_127521_((Throwable)t, (String)message), popup::close);
                }
            }, Runnable::run);
        }
        Futures.addCallback(future, (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(@Nullable Void result) {
                andThen.run();
            }

            public void onFailure(@Nonnull Throwable t) {
            }
        }, Runnable::run);
    }

    public void setQuickMode(boolean quickMode) {
        if (ReplayMod.isMinimalMode()) {
            throw new UnsupportedOperationException("Quick Mode not supported in minimal mode.");
        }
        if (quickMode == this.quickMode) {
            return;
        }
        if (quickMode && this.fullReplaySender.isAsyncMode()) {
            throw new IllegalStateException("Cannot switch to quick mode while in async mode.");
        }
        this.quickMode = quickMode;
        CameraEntity cam = this.getCameraEntity();
        this.targetCameraPosition = cam != null ? new Location(cam.m_20185_(), cam.m_20186_(), cam.m_20189_(), cam.m_146908_(), cam.m_146909_()) : null;
        if (quickMode) {
            this.quickReplaySender.register();
            this.quickReplaySender.restart();
            this.quickReplaySender.sendPacketsTill(this.fullReplaySender.currentTimeStamp());
        } else {
            this.quickReplaySender.unregister();
            this.fullReplaySender.sendPacketsTill(0);
            this.fullReplaySender.sendPacketsTill(this.quickReplaySender.currentTimeStamp());
        }
        this.moveCameraToTargetPosition();
    }

    public boolean isQuickMode() {
        return this.quickMode;
    }

    public int getReplayDuration() {
        return this.replayDuration;
    }

    public boolean shouldSuppressCameraMovements() {
        return this.suppressCameraMovements;
    }

    public void setSuppressCameraMovements(boolean suppressCameraMovements) {
        this.suppressCameraMovements = suppressCameraMovements;
    }

    public void spectateEntity(Entity e) {
        CameraEntity cameraEntity = this.getCameraEntity();
        if (cameraEntity == null) {
            return;
        }
        if (e == null || e == cameraEntity) {
            this.spectating = null;
            e = cameraEntity;
        } else if (e instanceof Player) {
            this.spectating = e.m_20148_();
        }
        if (e == cameraEntity) {
            cameraEntity.setCameraController(ReplayModReplay.instance.createCameraController(cameraEntity));
        } else {
            cameraEntity.setCameraController(new SpectatorCameraController(cameraEntity));
        }
        if (mc.m_91288_() != e) {
            mc.m_91118_(e);
            cameraEntity.setCameraPosRot((Entity)e);
        }
    }

    public void spectateCamera() {
        this.spectateEntity(null);
    }

    public boolean isCameraView() {
        return ReplayHandler.mc.f_91074_ instanceof CameraEntity && ReplayHandler.mc.f_91074_ == mc.m_91288_();
    }

    public CameraEntity getCameraEntity() {
        return ReplayHandler.mc.f_91074_ instanceof CameraEntity ? (CameraEntity)ReplayHandler.mc.f_91074_ : null;
    }

    public UUID getSpectatedUUID() {
        return this.spectating;
    }

    public void moveCameraToTargetPosition() {
        CameraEntity cam = this.getCameraEntity();
        if (cam != null && this.targetCameraPosition != null) {
            cam.setCameraPosRot(this.targetCameraPosition);
        }
    }

    public void doJump(int targetTime, boolean retainCameraPosition) {
        long diff;
        if (!this.getReplaySender().isAsyncMode()) {
            return;
        }
        if (this.getReplaySender() == this.quickReplaySender) {
            if ((targetTime += targetTime % 50) >= 50) {
                this.quickReplaySender.sendPacketsTill(targetTime - 50);
            }
            for (Entity entity : ReplayHandler.mc.f_91073_.m_104735_()) {
                this.skipTeleportInterpolation(entity);
                entity.f_19790_ = entity.f_19854_ = entity.m_20185_();
                entity.f_19791_ = entity.f_19855_ = entity.m_20186_();
                entity.f_19792_ = entity.f_19856_ = entity.m_20189_();
                entity.f_19859_ = entity.m_146908_();
                entity.f_19860_ = entity.m_146909_();
            }
            mc.m_91398_();
            this.quickReplaySender.sendPacketsTill(targetTime);
            for (Entity entity : ReplayHandler.mc.f_91073_.m_104735_()) {
                this.skipTeleportInterpolation(entity);
            }
            return;
        }
        FullReplaySender replaySender = this.fullReplaySender;
        if (replaySender.isHurrying()) {
            return;
        }
        if (targetTime < replaySender.currentTimeStamp()) {
            mc.m_91152_(null);
        }
        if (retainCameraPosition) {
            CameraEntity cam = this.getCameraEntity();
            this.targetCameraPosition = cam != null ? new Location(cam.m_20185_(), cam.m_20186_(), cam.m_20189_(), cam.m_146908_(), cam.m_146909_()) : null;
        }
        if ((diff = (long)targetTime - (replaySender.isHurrying() ? replaySender.getDesiredTimestamp() : (long)replaySender.currentTimeStamp())) != 0L) {
            if (diff > 0L && diff < 5000L) {
                replaySender.jumpToTime(targetTime);
            } else {
                GuiScreen guiScreen = new GuiScreen();
                guiScreen.setBackground(AbstractGuiScreen.Background.DIRT);
                guiScreen.setLayout(new HorizontalLayout(HorizontalLayout.Alignment.CENTER));
                guiScreen.addElements(new HorizontalLayout.Data(0.5), new GuiElement[]{new GuiLabel().setI18nText("replaymod.gui.pleasewait", new Object[0])});
                replaySender.setSyncModeAndWait();
                MCVer.pushMatrix();
                RenderSystem.clear((int)16640, (boolean)true);
                mc.m_91385_().m_83947_(true);
                Window window = mc.m_91268_();
                RenderSystem.clear((int)256, (boolean)Minecraft.f_91002_);
                RenderSystem.setProjectionMatrix((Matrix4f)MCVer.ortho(0.0f, (float)((double)window.m_85441_() / window.m_85449_()), 0.0f, (float)((double)window.m_85442_() / window.m_85449_()), 1000.0f, 3000.0f), (VertexSorting)VertexSorting.f_276633_);
                PoseStack matrixStack = RenderSystem.getModelViewStack();
                matrixStack.m_166856_();
                matrixStack.m_252880_(0.0f, 0.0f, -2000.0f);
                RenderSystem.applyModelViewMatrix();
                Lighting.m_84931_();
                guiScreen.toMinecraft().m_6575_(mc, window.m_85445_(), window.m_85446_());
                guiScreen.toMinecraft().m_88315_(new GuiGraphics(mc, mc.m_91269_().m_110104_()), 0, 0, 0.0f);
                guiScreen.toMinecraft().m_7861_();
                mc.m_91385_().m_83970_();
                MCVer.popMatrix();
                MCVer.pushMatrix();
                mc.m_91385_().m_83938_(mc.m_91268_().m_85441_(), mc.m_91268_().m_85442_());
                MCVer.popMatrix();
                mc.m_91268_().m_85435_();
                do {
                    replaySender.sendPacketsTill(targetTime);
                    targetTime += 500;
                } while (ReplayHandler.mc.f_91074_ == null || ReplayHandler.mc.f_91080_ instanceof ReceivingLevelScreen);
                replaySender.setAsyncMode(true);
                replaySender.setReplaySpeed(0.0);
                mc.m_91403_().m_104910_().m_129483_();
                if (ReplayHandler.mc.f_91073_ == null) {
                    return;
                }
                for (Entity entity : ReplayHandler.mc.f_91073_.m_104735_()) {
                    this.skipTeleportInterpolation(entity);
                    entity.f_19790_ = entity.f_19854_ = entity.m_20185_();
                    entity.f_19791_ = entity.f_19855_ = entity.m_20186_();
                    entity.f_19792_ = entity.f_19856_ = entity.m_20189_();
                    entity.f_19859_ = entity.m_146908_();
                    entity.f_19860_ = entity.m_146909_();
                }
                mc.m_91398_();
                this.moveCameraToTargetPosition();
            }
        }
    }

    private void skipTeleportInterpolation(Entity entity) {
        if (entity instanceof LivingEntity && !(entity instanceof CameraEntity)) {
            LivingEntity e = (LivingEntity)entity;
            EntityLivingBaseAccessor ea = (EntityLivingBaseAccessor)e;
            e.m_20248_(ea.getInterpTargetX(), ea.getInterpTargetY(), ea.getInterpTargetZ());
            e.m_146922_((float)ea.getInterpTargetYaw());
            e.m_146926_((float)ea.getInterpTargetPitch());
        }
    }

    private class InitializingQuickModePopup
    extends AbstractGuiPopup<InitializingQuickModePopup> {
        private final GuiProgressBar progressBar;

        public InitializingQuickModePopup(GuiContainer container) {
            super(container);
            this.progressBar = (GuiProgressBar)((GuiProgressBar)new GuiProgressBar(this.popup).setSize(300, 20)).setI18nLabel("replaymod.gui.loadquickmode", new Object[0]);
            this.open();
        }

        @Override
        public void close() {
            super.close();
        }

        @Override
        protected InitializingQuickModePopup getThis() {
            return this;
        }
    }
}

