/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.render.gui.progress;

import com.mojang.blaze3d.pipeline.MainTarget;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.Window;
import com.replaymod.render.hooks.MinecraftClientExt;
import com.replaymod.render.mixin.MainWindowAccessor;
import de.johni0702.minecraft.gui.function.Closeable;
import net.minecraft.client.Minecraft;

public class VirtualWindow
implements Closeable {
    private final Minecraft mc;
    private final Window window;
    private final MainWindowAccessor acc;
    private final RenderTarget guiFramebuffer;
    private boolean isBound;
    private int framebufferWidth;
    private int framebufferHeight;
    private int gameWidth;
    private int gameHeight;

    public VirtualWindow(Minecraft mc) {
        this.mc = mc;
        this.window = mc.m_91268_();
        this.acc = (MainWindowAccessor)this.window;
        this.framebufferWidth = this.acc.getFramebufferWidth();
        this.framebufferHeight = this.acc.getFramebufferHeight();
        this.guiFramebuffer = new MainTarget(this.framebufferWidth, this.framebufferHeight);
        MinecraftClientExt.get(mc).setWindowDelegate(this);
    }

    @Override
    public void close() {
        this.guiFramebuffer.m_83930_();
        MinecraftClientExt.get(this.mc).setWindowDelegate(null);
    }

    public void bind() {
        this.gameWidth = this.acc.getFramebufferWidth();
        this.gameHeight = this.acc.getFramebufferHeight();
        this.acc.setFramebufferWidth(this.framebufferWidth);
        this.acc.setFramebufferHeight(this.framebufferHeight);
        this.applyScaleFactor();
        this.isBound = true;
    }

    public void unbind() {
        this.acc.setFramebufferWidth(this.gameWidth);
        this.acc.setFramebufferHeight(this.gameHeight);
        this.applyScaleFactor();
        this.isBound = false;
    }

    public void beginWrite() {
        this.guiFramebuffer.m_83947_(true);
    }

    public void endWrite() {
        this.guiFramebuffer.m_83970_();
    }

    public void flip() {
        this.guiFramebuffer.m_83938_(this.framebufferWidth, this.framebufferHeight);
        this.window.m_85435_();
    }

    public void onResolutionChanged(int newWidth, int newHeight) {
        if (newWidth == 0 || newHeight == 0) {
            return;
        }
        if (this.framebufferWidth == newWidth && this.framebufferHeight == newHeight) {
            return;
        }
        this.framebufferWidth = newWidth;
        this.framebufferHeight = newHeight;
        this.guiFramebuffer.m_83941_(newWidth, newHeight, false);
        this.applyScaleFactor();
        if (this.mc.f_91080_ != null) {
            this.mc.f_91080_.m_6574_(this.mc, this.window.m_85445_(), this.window.m_85446_());
        }
    }

    private void applyScaleFactor() {
        this.window.m_85378_((double)this.window.m_85385_(((Integer)this.mc.f_91066_.m_231928_().m_231551_()).intValue(), this.mc.m_91390_()));
    }

    public int getFramebufferWidth() {
        return this.framebufferWidth;
    }

    public int getFramebufferHeight() {
        return this.framebufferHeight;
    }

    public boolean isBound() {
        return this.isBound;
    }
}

