/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.render.gui;

import com.mojang.blaze3d.platform.NativeImage;
import com.replaymod.core.utils.Utils;
import com.replaymod.render.rendering.VideoRenderer;
import de.johni0702.minecraft.gui.GuiRenderer;
import de.johni0702.minecraft.gui.RenderInfo;
import de.johni0702.minecraft.gui.container.AbstractGuiScreen;
import de.johni0702.minecraft.gui.container.GuiPanel;
import de.johni0702.minecraft.gui.container.GuiScreen;
import de.johni0702.minecraft.gui.element.GuiButton;
import de.johni0702.minecraft.gui.element.GuiCheckbox;
import de.johni0702.minecraft.gui.element.GuiElement;
import de.johni0702.minecraft.gui.element.GuiLabel;
import de.johni0702.minecraft.gui.element.advanced.GuiProgressBar;
import de.johni0702.minecraft.gui.function.Tickable;
import de.johni0702.minecraft.gui.layout.CustomLayout;
import de.johni0702.minecraft.gui.layout.HorizontalLayout;
import de.johni0702.minecraft.gui.utils.lwjgl.Dimension;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadableDimension;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadablePoint;
import java.nio.ByteBuffer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;

public class GuiVideoRenderer
extends GuiScreen
implements Tickable {
    private static final ResourceLocation NO_PREVIEW_TEXTURE = new ResourceLocation("replaymod", "logo.png");
    private final VideoRenderer renderer;
    public final GuiLabel title = (GuiLabel)new GuiLabel().setI18nText("replaymod.gui.rendering.title", new Object[0]);
    public final GuiPanel imagePanel = (GuiPanel)new GuiPanel(){

        @Override
        public void draw(GuiRenderer renderer, ReadableDimension size, RenderInfo renderInfo) {
            if (GuiVideoRenderer.this.previewCheckbox.isChecked()) {
                GuiVideoRenderer.this.renderPreview(renderer, size);
            } else {
                GuiVideoRenderer.this.renderNoPreview(renderer, size);
            }
        }
    }.setSize(Integer.MAX_VALUE, Integer.MAX_VALUE);
    public final GuiCheckbox previewCheckbox = (GuiCheckbox)new GuiCheckbox().setI18nLabel("replaymod.gui.rendering.preview", new Object[0]);
    public final GuiLabel renderTime = new GuiLabel();
    public final GuiLabel remainingTime = new GuiLabel();
    public final GuiProgressBar progressBar = new GuiProgressBar();
    public final GuiPanel buttonPanel = (GuiPanel)new GuiPanel().setLayout(new HorizontalLayout().setSpacing(4));
    public final GuiButton pauseButton = (GuiButton)((GuiButton)((GuiButton)new GuiButton(this.buttonPanel).onClick(new Runnable(){

        @Override
        public void run() {
            if (GuiVideoRenderer.this.renderer.isPaused()) {
                GuiVideoRenderer.this.pauseButton.setI18nLabel("replaymod.gui.rendering.pause", new Object[0]);
                GuiVideoRenderer.this.renderer.setPaused(false);
            } else {
                GuiVideoRenderer.this.pauseButton.setI18nLabel("replaymod.gui.rendering.resume", new Object[0]);
                GuiVideoRenderer.this.renderer.setPaused(true);
            }
        }
    })).setI18nLabel("replaymod.gui.rendering.pause", new Object[0])).setSize(150, 20);
    public final GuiButton cancelButton = (GuiButton)((GuiButton)new GuiButton(this.buttonPanel){
        boolean waitingForConfirmation;

        @Override
        public boolean mouseClick(ReadablePoint position, int button) {
            boolean result = super.mouseClick(position, button);
            if (this.waitingForConfirmation && !result) {
                this.setI18nLabel("replaymod.gui.rendering.cancel", new Object[0]);
                this.waitingForConfirmation = false;
            }
            return result;
        }

        @Override
        public void onClick() {
            super.onClick();
            if (!this.waitingForConfirmation) {
                this.setI18nLabel("replaymod.gui.rendering.cancel.callback", new Object[0]);
                this.waitingForConfirmation = true;
            } else {
                GuiVideoRenderer.this.renderer.cancel();
            }
        }
    }.setI18nLabel("replaymod.gui.rendering.cancel", new Object[0])).setSize(150, 20);
    private DynamicTexture previewTexture;
    private boolean previewTextureDirty;
    private int renderTimeTaken;
    private long prevTime;
    private long frameStartTime;
    private int prevRenderedFrames;
    private int renderTimeLeft;
    private int[] renderTimes;
    private int currentIndex;

    public GuiVideoRenderer(VideoRenderer renderer) {
        final GuiPanel contentPanel = (GuiPanel)((GuiPanel)new GuiPanel(this).setLayout(new CustomLayout<GuiPanel>(){

            @Override
            protected void layout(GuiPanel container, int width, int height) {
                this.size(GuiVideoRenderer.this.progressBar, width, 20);
                this.pos(GuiVideoRenderer.this.title, width / 2 - this.width(GuiVideoRenderer.this.title) / 2, 0);
                this.pos(GuiVideoRenderer.this.imagePanel, 0, this.y(GuiVideoRenderer.this.title) + this.height(GuiVideoRenderer.this.title) + 5);
                this.pos(GuiVideoRenderer.this.buttonPanel, width / 2 - this.width(GuiVideoRenderer.this.buttonPanel) / 2, height - this.height(GuiVideoRenderer.this.buttonPanel));
                this.pos(GuiVideoRenderer.this.progressBar, width / 2 - this.width(GuiVideoRenderer.this.progressBar) / 2, this.y(GuiVideoRenderer.this.buttonPanel) - 5 - this.height(GuiVideoRenderer.this.progressBar));
                this.pos(GuiVideoRenderer.this.renderTime, 0, this.y(GuiVideoRenderer.this.progressBar) - 2 - this.height(GuiVideoRenderer.this.renderTime));
                this.pos(GuiVideoRenderer.this.remainingTime, width - this.width(GuiVideoRenderer.this.remainingTime), this.y(GuiVideoRenderer.this.progressBar) - 2 - this.height(GuiVideoRenderer.this.renderTime));
                this.pos(GuiVideoRenderer.this.previewCheckbox, width / 2 - this.width(GuiVideoRenderer.this.previewCheckbox) / 2, this.y(GuiVideoRenderer.this.renderTime) - 10 - this.height(GuiVideoRenderer.this.previewCheckbox));
                this.size(GuiVideoRenderer.this.imagePanel, width, this.y(GuiVideoRenderer.this.previewCheckbox) - 5 - this.y(GuiVideoRenderer.this.imagePanel));
            }
        })).addElements(null, new GuiElement[]{this.title, this.imagePanel, this.previewCheckbox, this.renderTime, this.remainingTime, this.progressBar, this.buttonPanel});
        this.setLayout(new CustomLayout<GuiScreen>(){

            @Override
            protected void layout(GuiScreen container, int width, int height) {
                this.pos(contentPanel, 5, 3);
                this.size(contentPanel, width - 10, height - 10);
            }
        });
        this.setBackground(AbstractGuiScreen.Background.DIRT);
        this.renderTimeTaken = 0;
        this.prevTime = -1L;
        this.frameStartTime = -1L;
        this.prevRenderedFrames = 0;
        this.renderTimeLeft = 0;
        this.renderTimes = new int[50];
        this.currentIndex = 0;
        this.renderer = renderer;
    }

    @Override
    public void tick() {
        long current = System.nanoTime() / 1000000L;
        if (!this.renderer.isPaused() && this.renderer.getFramesDone() > 0 && this.prevTime > -1L) {
            this.renderTimeTaken = (int)((long)this.renderTimeTaken + (current - this.prevTime));
        } else {
            this.frameStartTime = current;
        }
        this.prevTime = current;
        if (this.prevRenderedFrames < this.renderer.getFramesDone()) {
            if (this.prevRenderedFrames > 0) {
                int framesRendered = this.renderer.getFramesDone() - this.prevRenderedFrames;
                int renderTime = (int)(current - this.frameStartTime);
                int avgRenderTime = renderTime / framesRendered;
                for (int i = 0; i < framesRendered; ++i) {
                    this.renderTimes[this.currentIndex] = avgRenderTime;
                    ++this.currentIndex;
                    if (this.currentIndex < this.renderTimes.length) continue;
                    this.currentIndex = 0;
                }
                int validValues = 0;
                int totalTime = 0;
                for (int i : this.renderTimes) {
                    if (i <= 0) continue;
                    totalTime += i;
                    ++validValues;
                }
                float averageRenderTime = validValues > 0 ? (float)(totalTime / validValues) : 0.0f;
                this.renderTimeLeft = Math.round(averageRenderTime * (float)(this.renderer.getTotalFrames() - this.renderer.getFramesDone()) / 1000.0f);
            }
            this.frameStartTime = current;
            this.prevRenderedFrames = this.renderer.getFramesDone();
        }
        this.renderTime.setText(I18n.m_118938_((String)"replaymod.gui.rendering.timetaken", (Object[])new Object[0]) + ": " + this.secToString(this.renderTimeTaken / 1000));
        this.remainingTime.setText(I18n.m_118938_((String)"replaymod.gui.rendering.timeleft", (Object[])new Object[0]) + ": " + this.secToString(this.renderTimeLeft));
        int framesDone = this.renderer.getFramesDone();
        int framesTotal = this.renderer.getTotalFrames();
        this.progressBar.setI18nLabel("replaymod.gui.rendering.progress", new Object[]{framesDone, framesTotal});
        this.progressBar.setProgress((float)framesDone / (float)framesTotal);
    }

    private String secToString(int seconds) {
        int hours = seconds / 3600;
        int min = seconds / 60 - hours * 60;
        int sec = seconds - (min * 60 + hours * 60 * 60);
        StringBuilder builder = new StringBuilder();
        if (hours > 0) {
            builder.append(hours).append(I18n.m_118938_((String)"replaymod.gui.hours", (Object[])new Object[0]));
        }
        if (min > 0 || hours > 0) {
            builder.append(min).append(I18n.m_118938_((String)"replaymod.gui.minutes", (Object[])new Object[0]));
        }
        builder.append(sec).append(I18n.m_118938_((String)"replaymod.gui.seconds", (Object[])new Object[0]));
        return builder.toString();
    }

    private synchronized void renderPreview(GuiRenderer guiRenderer, ReadableDimension size) {
        ReadableDimension videoSize = this.renderer.getFrameSize();
        int videoWidth = videoSize.getWidth();
        int videoHeight = videoSize.getHeight();
        if (this.previewTexture == null) {
            this.previewTexture = new DynamicTexture(videoWidth, videoHeight, true);
        }
        if (this.previewTextureDirty) {
            this.previewTexture.m_117985_();
            this.previewTextureDirty = false;
        }
        guiRenderer.bindTexture(this.previewTexture.m_117963_());
        this.renderPreviewTexture(guiRenderer, size, videoWidth, videoHeight);
    }

    private void renderNoPreview(GuiRenderer guiRenderer, ReadableDimension size) {
        guiRenderer.bindTexture(NO_PREVIEW_TEXTURE);
        this.renderPreviewTexture(guiRenderer, size, 1280, 720);
    }

    private void renderPreviewTexture(GuiRenderer guiRenderer, ReadableDimension size, int videoWidth, int videoHeight) {
        Dimension dimension = Utils.fitIntoBounds((ReadableDimension)new Dimension(videoWidth, videoHeight), size);
        int width = dimension.getWidth();
        int height = dimension.getHeight();
        int x = (size.getWidth() - width) / 2;
        int y = (size.getHeight() - height) / 2;
        guiRenderer.drawTexturedRect(x, y, 0, 0, width, height, videoWidth, videoHeight, videoWidth, videoHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePreview(ByteBuffer buffer, ReadableDimension size) {
        if (this.previewCheckbox.isChecked() && this.previewTexture != null) {
            buffer.mark();
            GuiVideoRenderer guiVideoRenderer = this;
            synchronized (guiVideoRenderer) {
                NativeImage data = this.previewTexture.m_117991_();
                assert (data != null);
                int width = size.getWidth();
                for (int y = 0; y < size.getHeight(); ++y) {
                    for (int x = 0; x < width; ++x) {
                        int b = buffer.get() & 0xFF;
                        int g = buffer.get() & 0xFF;
                        int r = buffer.get() & 0xFF;
                        buffer.get();
                        int value = 0xFF000000 | b << 16 | g << 8 | r;
                        data.m_84988_(x, y, value);
                    }
                }
                this.previewTextureDirty = true;
            }
            buffer.reset();
        }
    }
}

