/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.render.capturer;

import com.replaymod.render.capturer.CaptureData;
import com.replaymod.render.capturer.OpenGlFrameCapturer;
import com.replaymod.render.capturer.RenderInfo;
import com.replaymod.render.capturer.WorldRenderer;
import com.replaymod.render.frame.CubicOpenGlFrame;
import com.replaymod.render.rendering.Channel;
import java.util.Collections;
import java.util.Map;

public class CubicOpenGlFrameCapturer
extends OpenGlFrameCapturer<CubicOpenGlFrame, Data> {
    private final int frameSize;

    public CubicOpenGlFrameCapturer(WorldRenderer worldRenderer, RenderInfo renderInfo, int frameSize) {
        super(worldRenderer, renderInfo);
        this.frameSize = frameSize;
        worldRenderer.setOmnidirectional(true);
    }

    @Override
    protected int getFrameWidth() {
        return this.frameSize;
    }

    @Override
    protected int getFrameHeight() {
        return this.frameSize;
    }

    @Override
    public Map<Channel, CubicOpenGlFrame> process() {
        float partialTicks = this.renderInfo.updateForNextFrame();
        int frameId = this.framesDone++;
        CubicOpenGlFrame frame = new CubicOpenGlFrame(this.renderFrame(frameId, partialTicks, Data.LEFT), this.renderFrame(frameId, partialTicks, Data.RIGHT), this.renderFrame(frameId, partialTicks, Data.FRONT), this.renderFrame(frameId, partialTicks, Data.BACK), this.renderFrame(frameId, partialTicks, Data.TOP), this.renderFrame(frameId, partialTicks, Data.BOTTOM));
        return Collections.singletonMap(Channel.BRGA, frame);
    }

    public static enum Data implements CaptureData
    {
        LEFT,
        RIGHT,
        FRONT,
        BACK,
        TOP,
        BOTTOM;

    }
}

