/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.render.blend;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.blender.utils.MainLib;
import org.cakelab.blender.generator.typemap.Renaming;
import org.cakelab.blender.io.BlenderFile;
import org.cakelab.blender.io.FileVersionInfo;
import org.cakelab.blender.io.block.Block;
import org.cakelab.blender.io.block.BlockCodes;
import org.cakelab.blender.io.block.BlockTable;
import org.cakelab.blender.metac.CMetaModel;
import org.cakelab.blender.metac.CStruct;
import org.cakelab.blender.nio.CArrayFacade;
import org.cakelab.blender.nio.CFacade;
import org.cakelab.blender.nio.CPointer;
import org.cakelab.json.JSONArray;
import org.cakelab.json.JSONObject;
import org.cakelab.json.codec.JSONCodec;
import org.cakelab.json.codec.JSONCodecConfiguration;
import org.cakelab.json.codec.JSONCodecException;

public class ToJson {
    private static final String PACKAGE = "org.blender.dna";
    private static JSONCodec codec;
    private static CMetaModel model;
    private static BlenderFile blend;
    private static BlockTable blockTable;

    public static void main(String[] args) throws IOException, JSONCodecException {
        File fBlend = new File("/home/user/1.blend");
        blend = new BlenderFile(fBlend);
        FileVersionInfo versions = blend.readFileGlobal();
        if (!MainLib.doVersionCheck((FileVersionInfo)versions)) {
            System.err.println("Warning: Conversion will probably fail due to version mismatch!");
        }
        blockTable = blend.getBlockTable();
        model = blend.getMetaModel();
        codec = new JSONCodec(new JSONCodecConfiguration(false));
        JSONObject json = new JSONObject();
        JSONObject oHeader = ToJson.createHeader(blend);
        json.put((Object)"header", (Object)oHeader);
        JSONArray aBlocks = new JSONArray();
        json.put((Object)"blocks", (Object)aBlocks);
        for (Block b : blend.getBlocks()) {
            ToJson.addBlock(aBlocks, b);
        }
        blend.close();
        File fJsonOut = new File(fBlend.getParentFile(), fBlend.getName().replace(".blend", ".json"));
        FileOutputStream fout = new FileOutputStream(fJsonOut);
        codec.encodeObject((Object)json, (OutputStream)fout);
        fout.close();
        System.out.println("Finished");
    }

    private static JSONObject createHeader(BlenderFile blend) {
        JSONObject oHeader = new JSONObject();
        oHeader.put((Object)"MAGIC", (Object)"BLENDER");
        oHeader.put((Object)"addressWidth", (Object)blend.getEncoding().getAddressWidth());
        oHeader.put((Object)"endianess", (Object)blend.getEncoding().getByteOrder().toString());
        oHeader.put((Object)"version", (Object)blend.getVersion().toString());
        return oHeader;
    }

    private static void addBlock(JSONArray aBlocks, Block b) throws JSONCodecException, IOException {
        JSONObject oBlock = new JSONObject();
        aBlocks.add((Object)oBlock);
        JSONObject header = (JSONObject)codec.encodeObjectJSON((Object)b.header);
        oBlock.put((Object)"header", (Object)header);
        header.put((Object)"code", (Object)b.header.getCode().toString());
        CStruct struct = model.getStruct(b.header.getSdnaIndex());
        header.put((Object)"sdnaIndex", (Object)(struct.getSignature() + "(" + b.header.getSdnaIndex() + ")"));
        System.out.print("[" + b.header.getAddress() + ", " + (b.header.getAddress() + (long)b.header.getSize()) + "] ");
        if (b.header.getCode().equals((Object)BlockCodes.ID_DATA) && b.header.getSdnaIndex() == 0) {
            System.out.println(b.header.getCode().toString() + ": Link(0) or undef");
            byte[] buffer = new byte[b.header.getSize()];
            b.data.readFully(buffer);
            String str = ToJson.toHexStr(buffer);
            oBlock.put((Object)"raw", (Object)str);
            int requiredSize = b.header.getCount() * struct.sizeof(blend.getEncoding().getAddressWidth());
            if (requiredSize == b.header.getSize()) {
                ToJson.addStruct(oBlock, b, struct);
            }
        } else {
            System.out.println(b.header.getCode().toString() + ": " + struct.getSignature());
            ToJson.addStruct(oBlock, b, struct);
        }
    }

    private static String toHexStr(byte[] buffer) {
        StringBuffer str = new StringBuffer();
        for (byte v : buffer) {
            Object s = Integer.toHexString(v & 0xFF);
            if (((String)s).length() == 1) {
                s = "0" + (String)s;
            }
            str.append((String)s);
        }
        return str.toString();
    }

    private static void addStruct(JSONObject oBlock, Block b, CStruct struct) {
        if (b.header.getCount() == 1) {
            oBlock.put((Object)struct.getSignature(), ToJson.createStruct(b, 0, struct));
        } else {
            JSONArray aStructs = new JSONArray();
            oBlock.put((Object)(struct.getSignature() + "_array"), (Object)aStructs);
            for (int i = 0; i < b.header.getCount(); ++i) {
                aStructs.add(ToJson.createStruct(b, i, struct));
            }
        }
    }

    private static Object createStruct(Block b, int index, CStruct struct) {
        JSONObject oStruct = null;
        try {
            Class<?> cStruct = Class.forName("org.blender.dna." + Renaming.mapStruct2Class((String)struct.getSignature()));
            long address = b.header.getAddress() + (long)(index * struct.sizeof(blend.getEncoding().getAddressWidth()));
            Constructor<?> constructor = cStruct.getDeclaredConstructor(Long.TYPE, Block.class, BlockTable.class);
            Object object = constructor.newInstance(address, b, blockTable);
            oStruct = (JSONObject)ToJson.toJson(cStruct, object);
        }
        catch (Throwable e) {
            oStruct = new JSONObject();
            e.printStackTrace();
            oStruct.put((Object)"error", (Object)(e.getClass().getSimpleName() + ": " + e.getMessage()));
        }
        return oStruct;
    }

    private static Object toJson(Class<?> type, Object value) throws Throwable {
        try {
            assert (value != null);
            if (ToJson.isPrimitive(type)) {
                return codec.encodeObjectJSON(value);
            }
            if (value instanceof CArrayFacade) {
                CArrayFacade carray = (CArrayFacade)value;
                JSONArray array = new JSONArray();
                boolean hasString = false;
                for (int i = 0; i < carray.length(); ++i) {
                    Object elem = carray.get(i);
                    if (elem instanceof Byte) {
                        hasString = true;
                    }
                    array.add(ToJson.toJson(elem.getClass(), elem));
                }
                if (hasString) {
                    JSONObject debugArray = new JSONObject();
                    debugArray.put((Object)"str", (Object)carray.asString());
                    debugArray.put((Object)"data", (Object)array);
                    return debugArray;
                }
                return array;
            }
            if (value instanceof CPointer) {
                return ((CPointer)value).getAddress();
            }
            if (value instanceof CFacade) {
                JSONObject oStruct = new JSONObject();
                try {
                    for (Method getter : type.getDeclaredMethods()) {
                        if (!getter.getName().startsWith("get")) continue;
                        Object result = getter.invoke(value, new Object[0]);
                        Class<?> rType = getter.getReturnType();
                        oStruct.put((Object)getter.getName(), ToJson.toJson(rType, result));
                    }
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof NullPointerException) {
                        throw (NullPointerException)cause;
                    }
                    throw e;
                }
                return oStruct;
            }
            return codec.encodeObjectJSON(value);
        }
        catch (NullPointerException e) {
            JSONObject o = new JSONObject();
            o.put((Object)"error", (Object)"data not found");
            return o;
        }
    }

    private static boolean isPrimitive(Class<?> type) {
        return type.isPrimitive() || type.equals(String.class);
    }
}

