/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.render.blend;

import com.mojang.blaze3d.platform.MemoryTracker;
import com.replaymod.render.blend.data.DImage;
import com.replaymod.render.blend.data.DMaterial;
import com.replaymod.render.blend.data.DPackedFile;
import com.replaymod.render.blend.data.DTexture;
import de.johni0702.minecraft.gui.versions.Image;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;

public class BlendMaterials {
    private final Map<Integer, DMaterial> materials = new HashMap<Integer, DMaterial>();

    public DMaterial getActiveMaterial() {
        int textureId = GL11.glGetInteger((int)32873);
        DMaterial material = this.materials.get(textureId);
        if (material == null) {
            int width = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
            int height = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
            ByteBuffer buffer = MemoryTracker.m_182527_((int)(width * height * 4));
            GL11.glGetTexImage((int)3553, (int)0, (int)6408, (int)5121, (ByteBuffer)buffer);
            Image bufImage = new Image(width, height);
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    byte a = buffer.get();
                    byte b = buffer.get();
                    byte g = buffer.get();
                    byte r = buffer.get();
                    bufImage.setRGBA(x, y, r, b, g, a);
                }
            }
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            try {
                bufImage.writePNG(stream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            byte[] bytes = stream.toByteArray();
            DImage image = new DImage();
            image.id.name = "texture.png";
            image.filePath = "texture.png";
            image.packedFiles.add((Pair<String, DPackedFile>)Pair.of((Object)"texture.png", (Object)new DPackedFile(bytes)));
            DTexture texture = new DTexture();
            texture.image = image;
            DMaterial.DMTex mTex = new DMaterial.DMTex();
            mTex.texture = texture;
            material = new DMaterial();
            material.textures.add(mTex);
            this.materials.put(textureId, material);
        }
        return material;
    }
}

