/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.recording.packet;

import com.google.common.hash.Hashing;
import com.replaymod.core.versions.MCVer;
import com.replaymod.replaystudio.replay.ReplayFile;
import de.johni0702.minecraft.gui.utils.Consumer;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraft.client.resources.DownloadedPackSource;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundResourcePackPacket;
import net.minecraft.network.protocol.game.ServerboundResourcePackPacket;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResourcePackRecorder {
    private static final Logger logger = LogManager.getLogger();
    private static final Minecraft mc = MCVer.getMinecraft();
    private final ReplayFile replayFile;
    private int nextRequestId;

    public ResourcePackRecorder(ReplayFile replayFile) {
        this.replayFile = replayFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordResourcePack(Path file, int requestId) {
        block13: {
            try {
                byte[] bytes = Files.readAllBytes(file);
                String hash = Hashing.sha1().hashBytes(bytes).toString();
                boolean doWrite = false;
                ReplayFile replayFile = this.replayFile;
                synchronized (replayFile) {
                    Map<Integer, String> index = this.replayFile.getResourcePackIndex();
                    if (index == null) {
                        index = new HashMap<Integer, String>();
                    }
                    if (!index.containsValue(hash)) {
                        doWrite = true;
                    }
                    index.put(requestId, hash);
                    this.replayFile.writeResourcePackIndex(index);
                }
                if (!doWrite) break block13;
                try (OutputStream out = this.replayFile.writeResourcePack(hash);){
                    out.write(bytes);
                }
            }
            catch (IOException e) {
                logger.warn("Failed to save resource pack.", (Throwable)e);
            }
        }
    }

    public ServerboundResourcePackPacket makeStatusPacket(String hash, ServerboundResourcePackPacket.Action action) {
        return new ServerboundResourcePackPacket(action);
    }

    public synchronized ClientboundResourcePackPacket handleResourcePack(Connection netManager, ClientboundResourcePackPacket packet) {
        int requestId = this.nextRequestId++;
        String url = packet.m_132924_();
        String hash = packet.m_132927_();
        if (url.startsWith("level://")) {
            File savesDir = new File(ResourcePackRecorder.mc.f_91069_, "saves");
            String levelName = url.substring("level://".length());
            File levelDir = new File(savesDir, levelName);
            if (levelDir.isFile()) {
                netManager.m_129512_((Packet)this.makeStatusPacket(hash, ServerboundResourcePackPacket.Action.ACCEPTED));
                MCVer.addCallback(MCVer.setServerResourcePack(levelDir), result -> {
                    this.recordResourcePack(levelDir.toPath(), requestId);
                    netManager.m_129512_((Packet)this.makeStatusPacket(hash, ServerboundResourcePackPacket.Action.SUCCESSFULLY_LOADED));
                }, throwable -> netManager.m_129512_((Packet)this.makeStatusPacket(hash, ServerboundResourcePackPacket.Action.FAILED_DOWNLOAD)));
            } else {
                netManager.m_129512_((Packet)this.makeStatusPacket(hash, ServerboundResourcePackPacket.Action.FAILED_DOWNLOAD));
            }
        } else {
            ServerData serverData = mc.m_91089_();
            if (serverData != null && serverData.m_105387_() == ServerData.ServerPackStatus.ENABLED) {
                netManager.m_129512_((Packet)this.makeStatusPacket(hash, ServerboundResourcePackPacket.Action.ACCEPTED));
                this.downloadResourcePackFuture(netManager, requestId, url, hash);
            } else if (serverData != null && serverData.m_105387_() != ServerData.ServerPackStatus.PROMPT) {
                netManager.m_129512_((Packet)this.makeStatusPacket(hash, ServerboundResourcePackPacket.Action.DECLINED));
            } else {
                mc.execute(() -> mc.m_91152_((Screen)new ConfirmScreen(result -> {
                    if (serverData != null) {
                        serverData.m_105379_(result ? ServerData.ServerPackStatus.ENABLED : ServerData.ServerPackStatus.DISABLED);
                    }
                    if (result) {
                        netManager.m_129512_((Packet)this.makeStatusPacket(hash, ServerboundResourcePackPacket.Action.ACCEPTED));
                        this.downloadResourcePackFuture(netManager, requestId, url, hash);
                    } else {
                        netManager.m_129512_((Packet)this.makeStatusPacket(hash, ServerboundResourcePackPacket.Action.DECLINED));
                    }
                    ServerList.m_105446_((ServerData)serverData);
                    mc.m_91152_(null);
                }, (Component)Component.m_237115_((String)"multiplayer.texturePrompt.line1"), (Component)Component.m_237115_((String)"multiplayer.texturePrompt.line2"))));
            }
        }
        return new ClientboundResourcePackPacket("replay://" + requestId, "", packet.m_179188_(), packet.m_179189_());
    }

    private void downloadResourcePackFuture(Connection connection, int requestId, String url, String hash) {
        MCVer.addCallback(this.downloadResourcePack(requestId, url, hash), result -> connection.m_129512_((Packet)this.makeStatusPacket(hash, ServerboundResourcePackPacket.Action.SUCCESSFULLY_LOADED)), throwable -> connection.m_129512_((Packet)this.makeStatusPacket(hash, ServerboundResourcePackPacket.Action.FAILED_DOWNLOAD)));
    }

    private CompletableFuture<?> downloadResourcePack(int requestId, String url, String hash) {
        DownloadedPackSource packFinder = mc.m_247489_();
        ((IDownloadingPackFinder)packFinder).setRequestCallback(file -> this.recordResourcePack(file.toPath(), requestId));
        try {
            URL theUrl = new URL(url);
            String protocol = theUrl.getProtocol();
            if (!"http".equals(protocol) && !"https".equals(protocol)) {
                throw new MalformedURLException("Unsupported protocol.");
            }
            return packFinder.m_246254_(theUrl, hash, true);
        }
        catch (MalformedURLException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    public static interface IDownloadingPackFinder {
        public void setRequestCallback(Consumer<File> var1);
    }
}

