/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.recording.handler;

import com.replaymod.core.ReplayMod;
import com.replaymod.core.utils.ModCompat;
import com.replaymod.core.utils.Utils;
import com.replaymod.core.versions.MCVer;
import com.replaymod.recording.ServerInfoExt;
import com.replaymod.recording.Setting;
import com.replaymod.recording.gui.GuiRecordingControls;
import com.replaymod.recording.gui.GuiRecordingOverlay;
import com.replaymod.recording.handler.RecordingEventHandler;
import com.replaymod.recording.mixin.ClientLoginNetworkHandlerAccessor;
import com.replaymod.recording.mixin.NetworkManagerAccessor;
import com.replaymod.replaystudio.replay.ReplayFile;
import com.replaymod.replaystudio.replay.ReplayMetaData;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketListener;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.Logger;

public class ConnectionEventHandler {
    private static final String DATE_FORMAT = "yyyy_MM_dd_HH_mm_ss";
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
    private static final Minecraft mc = MCVer.getMinecraft();
    private final Logger logger;
    private final ReplayMod core;
    private RecordingEventHandler recordingEventHandler;
    private com.replaymod.recording.packet.PacketListener packetListener;
    private GuiRecordingOverlay guiOverlay;
    private GuiRecordingControls guiControls;

    public ConnectionEventHandler(Logger logger, ReplayMod core) {
        this.logger = logger;
        this.core = core;
    }

    public void onConnectedToServerEvent(Connection networkManager) {
        try {
            String worldName;
            ServerData serverData;
            PacketListener packetListener;
            boolean local = networkManager.m_129531_();
            if (local) {
                if (mc.m_91092_().m_129880_(Level.f_46428_).m_46659_()) {
                    this.logger.info("Debug World recording is not supported.");
                    return;
                }
                if (!this.core.getSettingsRegistry().get(Setting.RECORD_SINGLEPLAYER).booleanValue()) {
                    this.logger.info("Singleplayer Recording is disabled");
                    return;
                }
            } else if (!this.core.getSettingsRegistry().get(Setting.RECORD_SERVER).booleanValue()) {
                this.logger.info("Multiplayer Recording is disabled");
                return;
            }
            if ((packetListener = networkManager.m_129538_()) instanceof ClientLoginNetworkHandlerAccessor) {
                ClientLoginNetworkHandlerAccessor loginNetworkHandler = (ClientLoginNetworkHandlerAccessor)packetListener;
                serverData = loginNetworkHandler.getServerInfo();
            } else {
                serverData = null;
            }
            ServerData serverInfo = serverData;
            String serverName = null;
            boolean autoStart = this.core.getSettingsRegistry().get(Setting.AUTO_START_RECORDING);
            if (local) {
                serverName = worldName = mc.m_91092_().m_129910_().m_5462_();
            } else if (mc.m_91294_()) {
                worldName = "A Realms Server";
            } else if (serverInfo != null) {
                Boolean autoStartServer;
                worldName = serverInfo.f_105363_;
                if (!I18n.m_118938_((String)"selectServer.defaultName", (Object[])new Object[0]).equals(serverInfo.f_105362_)) {
                    serverName = serverInfo.f_105362_;
                }
                if ((autoStartServer = ServerInfoExt.from(serverInfo).getAutoRecording()) != null) {
                    autoStart = autoStartServer;
                }
            } else {
                this.logger.info("Recording not started as the world is neither local nor remote (probably a replay).");
                return;
            }
            if (ReplayMod.isMinimalMode()) {
                autoStart = true;
            }
            String name = sdf.format(Calendar.getInstance().getTime());
            Path outputPath = Utils.replayNameToPath(this.core.folders.getRecordingFolder(), name);
            ReplayFile replayFile = this.core.files.open(outputPath);
            replayFile.writeModInfo(ModCompat.getInstalledNetworkMods());
            ReplayMetaData metaData = new ReplayMetaData();
            metaData.setSingleplayer(local);
            metaData.setServerName(worldName);
            metaData.setCustomServerName(serverName);
            metaData.setGenerator("ReplayMod v" + ReplayMod.instance.getVersion());
            metaData.setDate(System.currentTimeMillis());
            metaData.setMcVersion(ReplayMod.instance.getMinecraftVersion());
            this.packetListener = new com.replaymod.recording.packet.PacketListener(this.core, outputPath, replayFile, metaData);
            Channel channel = ((NetworkManagerAccessor)networkManager).getChannel();
            if (channel.pipeline().get("decoder") != null) {
                channel.pipeline().addBefore("decoder", "replay_recorder_raw", (ChannelHandler)this.packetListener);
            } else {
                channel.pipeline().addFirst("replay_recorder_raw", (ChannelHandler)this.packetListener);
            }
            this.recordingEventHandler = new RecordingEventHandler(this.packetListener);
            this.recordingEventHandler.register();
            this.guiControls = new GuiRecordingControls(this.core, this.packetListener, autoStart);
            this.guiControls.register();
            this.guiOverlay = new GuiRecordingOverlay(mc, this.core.getSettingsRegistry(), this.guiControls);
            this.guiOverlay.register();
            if (autoStart) {
                this.core.printInfoToChat("replaymod.chat.recordingstarted", new Object[0]);
            } else {
                this.packetListener.addMarker("_RM_START_CUT", 0);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.core.printWarningToChat("replaymod.chat.recordingfailed", new Object[0]);
        }
    }

    public void reset() {
        if (this.packetListener != null) {
            this.guiControls.unregister();
            this.guiControls = null;
            this.guiOverlay.unregister();
            this.guiOverlay = null;
            this.recordingEventHandler.unregister();
            this.recordingEventHandler = null;
            this.packetListener = null;
        }
    }

    public com.replaymod.recording.packet.PacketListener getPacketListener() {
        return this.packetListener;
    }
}

