/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.recording.gui;

import com.replaymod.core.ReplayMod;
import com.replaymod.core.versions.MCVer;
import com.replaymod.recording.Setting;
import com.replaymod.render.utils.RenderJob;
import com.replaymod.replay.gui.screen.GuiReplayViewer;
import com.replaymod.replaystudio.replay.ReplayMetaData;
import de.johni0702.minecraft.gui.container.AbstractGuiScreen;
import de.johni0702.minecraft.gui.container.GuiContainer;
import de.johni0702.minecraft.gui.container.GuiPanel;
import de.johni0702.minecraft.gui.container.GuiScreen;
import de.johni0702.minecraft.gui.container.VanillaGuiScreen;
import de.johni0702.minecraft.gui.element.GuiButton;
import de.johni0702.minecraft.gui.element.GuiElement;
import de.johni0702.minecraft.gui.element.GuiLabel;
import de.johni0702.minecraft.gui.element.GuiTextField;
import de.johni0702.minecraft.gui.element.GuiTooltip;
import de.johni0702.minecraft.gui.element.advanced.GuiProgressBar;
import de.johni0702.minecraft.gui.function.Focusable;
import de.johni0702.minecraft.gui.layout.CustomLayout;
import de.johni0702.minecraft.gui.layout.HorizontalLayout;
import de.johni0702.minecraft.gui.layout.VerticalLayout;
import de.johni0702.minecraft.gui.utils.Colors;
import de.johni0702.minecraft.gui.utils.Utils;
import de.johni0702.minecraft.gui.utils.lwjgl.Dimension;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadableDimension;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.CrashReport;
import net.minecraft.client.Minecraft;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GuiSavingReplay {
    private static final Minecraft mc = MCVer.getMinecraft();
    private static final Logger logger = LogManager.getLogger();
    private final GuiLabel label = (GuiLabel)((GuiLabel)new GuiLabel().setI18nText("replaymod.gui.replaysaving.title", new Object[0])).setColor(Colors.BLACK);
    private final GuiProgressBar progressBar = (GuiProgressBar)new GuiProgressBar().setHeight(14);
    private final GuiPanel panel = (GuiPanel)((GuiPanel)new GuiPanel().setLayout(new VerticalLayout().setSpacing(2))).addElements(new VerticalLayout.Data(0.5), new GuiElement[]{this.label, this.progressBar});
    private final ReplayMod core;
    private final List<Runnable> apply = new ArrayList<Runnable>();

    public GuiSavingReplay(ReplayMod core) {
        this.core = core;
    }

    public void open() {
        this.core.getBackgroundProcesses().addProcess(this.panel);
    }

    public void close() {
        this.core.getBackgroundProcesses().removeProcess(this.panel);
        AbstractGuiScreen currentScreen = GuiScreen.from(GuiSavingReplay.mc.f_91080_);
        if (currentScreen instanceof GuiReplayViewer) {
            ((GuiReplayViewer)currentScreen).list.load();
        }
    }

    public GuiProgressBar getProgressBar() {
        return this.progressBar;
    }

    public void presentRenameDialog(List<Pair<Path, ReplayMetaData>> outputPaths) {
        this.panel.removeElement(this.progressBar);
        Utils.link((Focusable[])outputPaths.stream().map(it -> this.addOutput((Path)it.getKey(), (ReplayMetaData)it.getValue())).toArray(Focusable[]::new));
        GuiButton applyButton = (GuiButton)((GuiButton)((GuiButton)new GuiButton().setSize(150, 20)).setI18nLabel("replaymod.gui.done", new Object[0])).onClick(this::apply);
        this.panel.addElements(new VerticalLayout.Data(0.5), new GuiElement[]{applyButton});
        if (!this.core.getSettingsRegistry().get(Setting.RENAME_DIALOG).booleanValue()) {
            this.apply();
        }
    }

    private GuiTextField addOutput(Path path, ReplayMetaData metaData) {
        String originalName = com.replaymod.core.utils.Utils.fileNameToReplayName(path.getFileName().toString());
        GuiTextField textField = (GuiTextField)((GuiTextField)((GuiTextField)((GuiTextField)((GuiTextField)((GuiTextField)new GuiTextField().setSize(130, 20)).setText(originalName)).setI18nHint("replaymod.gui.delete", new Object[0])).setTextColorDisabled(Colors.RED)).onEnter(this::apply)).setTooltip(this.createTooltip(path, metaData));
        GuiButton clearButton = (GuiButton)((GuiButton)((GuiButton)((GuiButton)new GuiButton().setSize(20, 20)).setLabel("X")).setTooltip((GuiElement)new GuiTooltip().setI18nText("replaymod.gui.delete", new Object[0]))).onClick(() -> textField.setText(""));
        GuiPanel row = (GuiPanel)((GuiPanel)new GuiPanel().setLayout(new HorizontalLayout())).addElements(null, new GuiElement[]{textField, clearButton});
        this.panel.addElements(new VerticalLayout.Data(0.5), new GuiElement[]{row});
        this.apply.add(() -> this.applyOutput(path, textField.getText()));
        return textField;
    }

    private GuiPanel createTooltip(Path path, ReplayMetaData metaData) {
        final GuiTooltip tooltip = new GuiTooltip();
        final GuiReplayViewer.GuiReplayEntry entry = new GuiReplayViewer.GuiReplayEntry(path.toFile(), metaData, null, new ArrayList<RenderJob>());
        return (GuiPanel)((GuiPanel)new GuiPanel().setLayout(new CustomLayout<GuiPanel>(){

            @Override
            protected void layout(GuiPanel container, int width, int height) {
                this.pos(entry, 4, 4);
                this.size(entry, width - 8, height - 8);
                this.size(tooltip, width, height);
            }

            @Override
            public ReadableDimension calcMinSize(GuiContainer<?> container) {
                ReadableDimension size = entry.calcMinSize();
                return new Dimension(size.getWidth() + 8, size.getHeight() + 8);
            }
        })).addElements(null, new GuiElement[]{tooltip, entry});
    }

    private void apply() {
        this.apply.forEach(Runnable::run);
        this.close();
    }

    private void applyOutput(Path path, String newName) {
        if (newName.isEmpty()) {
            try {
                Files.delete(path);
            }
            catch (IOException e) {
                logger.error("Deleting replay file:", (Throwable)e);
                CrashReport crashReport = CrashReport.m_127521_((Throwable)e, (String)"Deleting replay file");
                this.core.runLater(() -> com.replaymod.core.utils.Utils.error(logger, VanillaGuiScreen.wrap(GuiSavingReplay.mc.f_91080_), crashReport, () -> {}));
            }
            return;
        }
        try {
            Path replaysFolder = this.core.folders.getReplayFolder();
            Path newPath = com.replaymod.core.utils.Utils.replayNameToPath(replaysFolder, newName);
            int i = 1;
            while (Files.exists(newPath, new LinkOption[0])) {
                newPath = com.replaymod.core.utils.Utils.replayNameToPath(replaysFolder, newName + " (" + i + ")");
                ++i;
            }
            Files.move(path, newPath, new CopyOption[0]);
        }
        catch (IOException e) {
            logger.error("Renaming replay file:", (Throwable)e);
            CrashReport crashReport = CrashReport.m_127521_((Throwable)e, (String)"Renaming replay file");
            this.core.runLater(() -> com.replaymod.core.utils.Utils.error(logger, VanillaGuiScreen.wrap(GuiSavingReplay.mc.f_91080_), crashReport, () -> {}));
        }
    }
}

