/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.extras.youtube;

import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.extensions.java6.auth.oauth2.AuthorizationCodeInstalledApp;
import com.google.api.client.extensions.java6.auth.oauth2.VerificationCodeReceiver;
import com.google.api.client.extensions.jetty.auth.oauth2.LocalServerReceiver;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeFlow;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.googleapis.media.MediaHttpUploader;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.InputStreamContent;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.util.store.DataStoreFactory;
import com.google.api.client.util.store.FileDataStoreFactory;
import com.google.api.services.youtube.YouTube;
import com.google.api.services.youtube.model.Video;
import com.google.api.services.youtube.model.VideoSnippet;
import com.google.api.services.youtube.model.VideoStatus;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.io.Files;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.replaymod.extras.ReplayModExtras;
import com.replaymod.extras.youtube.VideoVisibility;
import com.replaymod.render.RenderSettings;
import com.replaymod.render.metadata.MetadataInjector;
import de.johni0702.minecraft.gui.utils.NonNull;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.Minecraft;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.io.FileUtils;

public class YoutubeUploader {
    private static final String CLIENT_ID = "743126594724-mfe7pj1k7e47uu5pk4503c8st9vj9ibu.apps.googleusercontent.com";
    private static final String CLIENT_SECRET = "gMwcy3mRYCRamCIjJIYP7rqc";
    private static final String FFMPEG_MP4 = "-i %s -c:v libx264 -preset slow -crf 16 %s";
    private static final JsonFactory JSON_FACTORY = new GsonFactory();
    private final NetHttpTransport httpTransport;
    private final DataStoreFactory dataStoreFactory;
    private final File videoFile;
    private final int videoFrames;
    private final String thumbnailFormat;
    private final byte[] thumbnailImage;
    private final RenderSettings settings;
    private final VideoSnippet videoSnippet;
    private final VideoVisibility videoVisibility;
    private Thread thread;
    @NonNull
    private Supplier<Double> progress = Suppliers.ofInstance((Object)0.0);
    private State state;
    private volatile boolean cancelled;

    public YoutubeUploader(Minecraft minecraft, File videoFile, int videoFrames, String thumbnailFormat, byte[] thumbnailImage, RenderSettings settings, VideoVisibility videoVisibility, VideoSnippet videoSnippet) throws GeneralSecurityException, IOException {
        this.videoFile = videoFile;
        this.videoFrames = videoFrames;
        this.thumbnailImage = thumbnailImage;
        this.thumbnailFormat = thumbnailFormat;
        this.settings = settings;
        this.videoVisibility = videoVisibility;
        this.videoSnippet = videoSnippet;
        this.httpTransport = GoogleNetHttpTransport.newTrustedTransport();
        this.dataStoreFactory = new FileDataStoreFactory(minecraft.f_91069_);
    }

    public ListenableFuture<Video> upload() throws IOException {
        this.cancelled = false;
        SettableFuture future = SettableFuture.create();
        this.thread = new Thread(() -> {
            try {
                this.state = State.AUTH;
                Credential credential = this.auth();
                this.state = State.PREPARE_VIDEO;
                File processedFile = this.preUpload();
                this.progress = Suppliers.ofInstance((Object)0.0);
                YouTube youTube = new YouTube.Builder((HttpTransport)this.httpTransport, JSON_FACTORY, (HttpRequestInitializer)credential).setApplicationName("ReplayMod").build();
                this.state = State.UPLOAD;
                Video video = this.doUpload(youTube, processedFile);
                if (this.thumbnailImage != null) {
                    this.doThumbUpload(youTube, video);
                }
                this.state = State.CLEANUP;
                this.postUpload(processedFile);
                future.set((Object)video);
            }
            catch (Throwable t) {
                future.setException(t);
            }
        });
        this.thread.start();
        return future;
    }

    public void cancel() throws InterruptedException {
        this.thread.stop();
        this.cancelled = true;
    }

    private Credential auth() throws IOException {
        GoogleAuthorizationCodeFlow flow = new GoogleAuthorizationCodeFlow.Builder((HttpTransport)this.httpTransport, JSON_FACTORY, CLIENT_ID, CLIENT_SECRET, Collections.singleton("https://www.googleapis.com/auth/youtube.upload")).setDataStoreFactory(this.dataStoreFactory).build();
        return new AuthorizationCodeInstalledApp((AuthorizationCodeFlow)flow, (VerificationCodeReceiver)new LocalServerReceiver()).authorize("user");
    }

    private File preUpload() throws InterruptedException, IOException {
        File outputFile = this.videoFile;
        if (this.settings.getRenderMethod().isSpherical()) {
            boolean isMp4 = Files.getFileExtension((String)outputFile.getName()).equalsIgnoreCase("mp4");
            if (!isMp4) {
                int result;
                outputFile = new File(outputFile.getParentFile(), System.currentTimeMillis() + ".mp4");
                outputFile.deleteOnExit();
                String args = String.format(FFMPEG_MP4, this.videoFile.getName(), outputFile.getName());
                CommandLine commandLine = new CommandLine(this.settings.getExportCommandOrDefault());
                commandLine.addArguments(args);
                ReplayModExtras.LOGGER.info("Re-encoding for metadata injection with {} {}", (Object)commandLine.getExecutable(), (Object)args);
                Process process = new ProcessBuilder(commandLine.toStrings()).directory(outputFile.getParentFile()).start();
                AtomicBoolean active = new AtomicBoolean(true);
                InputStream in = process.getErrorStream();
                new Thread(() -> {
                    try {
                        StringBuilder sb = new StringBuilder();
                        while (active.get()) {
                            char c = (char)in.read();
                            if (c == '\r') {
                                String str = sb.toString();
                                ReplayModExtras.LOGGER.debug("[FFmpeg] {}", (Object)str);
                                if (str.startsWith("frame=")) {
                                    str = str.substring(6).trim();
                                    str = str.substring(0, str.indexOf(32));
                                    double frame = Integer.parseInt(str);
                                    this.progress = Suppliers.ofInstance((Object)(frame / (double)this.videoFrames));
                                }
                                sb = new StringBuilder();
                                continue;
                            }
                            sb.append(c);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }).start();
                try {
                    result = process.waitFor();
                }
                catch (InterruptedException e) {
                    process.destroy();
                    throw e;
                }
                finally {
                    active.set(false);
                }
                if (result != 0) {
                    throw new IOException("FFmpeg returned: " + result);
                }
            }
            if (!this.settings.isInjectSphericalMetadata() || !isMp4) {
                MetadataInjector.injectMetadata(this.settings.getRenderMethod(), outputFile, this.settings.getTargetVideoWidth(), this.settings.getTargetVideoHeight(), this.settings.getSphericalFovX(), this.settings.getSphericalFovY());
            }
        }
        return outputFile;
    }

    private Video doUpload(YouTube youTube, File processedFile) throws IOException {
        Video result;
        Video video = new Video();
        VideoStatus videoStatus = new VideoStatus();
        videoStatus.setPrivacyStatus(this.videoVisibility.name().toLowerCase());
        video.setStatus(videoStatus);
        video.setSnippet(this.videoSnippet);
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(processedFile));){
            InputStreamContent content = new InputStreamContent("video/*", (InputStream)inputStream);
            content.setLength(processedFile.length());
            YouTube.Videos.Insert videoInsert = youTube.videos().insert("snippet,statistics,status", video, (AbstractInputStreamContent)content);
            MediaHttpUploader uploader = videoInsert.getMediaHttpUploader();
            this.progress = () -> {
                try {
                    return uploader.getProgress();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            };
            result = (Video)videoInsert.execute();
        }
        return result;
    }

    private void doThumbUpload(YouTube youTube, Video video) throws IOException {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(this.thumbnailImage);){
            InputStreamContent content = new InputStreamContent("image/" + this.thumbnailFormat, (InputStream)inputStream);
            content.setLength((long)inputStream.available());
            youTube.thumbnails().set(video.getId(), (AbstractInputStreamContent)content).execute();
        }
        catch (GoogleJsonResponseException e) {
            GoogleJsonError.ErrorInfo info = (GoogleJsonError.ErrorInfo)e.getDetails().getErrors().get(0);
            if ("Authorization".equals(info.getLocation()) && "forbidden".equals(info.getReason())) {
                e.printStackTrace();
            }
            throw e;
        }
    }

    private void postUpload(File processedFile) {
        if (processedFile != this.videoFile) {
            FileUtils.deleteQuietly((File)processedFile);
        }
    }

    public double getProgress() {
        return (Double)this.progress.get();
    }

    public State getState() {
        return this.state;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public static enum State {
        AUTH,
        PREPARE_VIDEO,
        UPLOAD,
        CLEANUP;

    }
}

