/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.extras.advancedscreenshots;

import com.replaymod.core.ReplayMod;
import com.replaymod.core.utils.Utils;
import com.replaymod.extras.advancedscreenshots.GuiUploadScreenshot;
import com.replaymod.extras.advancedscreenshots.ScreenshotRenderer;
import com.replaymod.render.RenderSettings;
import com.replaymod.render.ReplayModRender;
import com.replaymod.render.gui.GuiRenderSettings;
import com.replaymod.replay.ReplayModReplay;
import de.johni0702.minecraft.gui.container.GuiContainer;
import de.johni0702.minecraft.gui.container.GuiPanel;
import de.johni0702.minecraft.gui.element.GuiButton;
import de.johni0702.minecraft.gui.element.GuiElement;
import de.johni0702.minecraft.gui.element.GuiLabel;
import de.johni0702.minecraft.gui.function.Loadable;
import de.johni0702.minecraft.gui.layout.GridLayout;
import de.johni0702.minecraft.gui.layout.VerticalLayout;
import java.io.File;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import net.minecraft.CrashReport;

public class GuiCreateScreenshot
extends GuiRenderSettings
implements Loadable {
    private final ReplayMod mod;

    public GuiCreateScreenshot(ReplayMod mod) {
        super(GuiRenderSettings.createBaseScreen(), null, null);
        this.mod = mod;
        this.resetChildren(this.settingsList.getListPanel()).addElements(new VerticalLayout.Data(0.5), new GuiElement[]{new GuiLabel().setI18nText("replaymod.gui.advancedscreenshots.title", new Object[0]), this.mainPanel, new GuiPanel(), new GuiLabel().setI18nText("replaymod.gui.rendersettings.advanced", new Object[0]), this.advancedPanel, new GuiPanel()});
        this.resetChildren(this.mainPanel).addElements(new GridLayout.Data(1.0, 0.5), new GuiElement[]{new GuiLabel().setI18nText("replaymod.gui.rendersettings.renderer", new Object[0]), this.renderMethodDropdown, new GuiLabel().setI18nText("replaymod.gui.advancedscreenshots.resolution", new Object[0]), this.videoResolutionPanel, new GuiLabel().setI18nText("replaymod.gui.rendersettings.outputfile", new Object[0]), this.outputFileButton});
        this.resetChildren(this.advancedPanel).addElements(null, new GuiElement[]{this.nametagCheckbox, this.alphaCheckbox, ((GuiPanel)new GuiPanel().setLayout(new GridLayout().setCellsEqualSize(false).setColumns(2).setSpacingX(5).setSpacingY(15))).addElements(new GridLayout.Data(0.0, 0.5), new GuiElement[]{new GuiLabel().setI18nText("replaymod.gui.rendersettings.stabilizecamera", new Object[0]), this.stabilizePanel, this.chromaKeyingCheckbox, this.chromaKeyingColor})});
        this.exportArguments.setText("");
        this.buttonPanel.removeElement(this.queueButton);
        ((GuiButton)this.renderButton.setI18nLabel("replaymod.gui.advancedscreenshots.create", new Object[0])).onClick(() -> {
            this.close();
            mod.runLater(() -> {
                try {
                    RenderSettings settings = this.save(false);
                    boolean success = new ScreenshotRenderer(settings).renderScreenshot();
                    if (success) {
                        new GuiUploadScreenshot(ReplayModReplay.instance.getReplayHandler().getOverlay(), mod, settings).open();
                    }
                }
                catch (Throwable t) {
                    Utils.error(ReplayModRender.LOGGER, this, CrashReport.m_127521_((Throwable)t, (String)"Rendering video"), () -> {});
                    this.getScreen().display();
                }
            });
        });
    }

    private <T extends GuiContainer<?>> T resetChildren(T container) {
        new ArrayList<GuiElement>(container.getChildren()).forEach(container::removeElement);
        return container;
    }

    @Override
    public void open() {
        super.open();
        this.getScreen().display();
    }

    @Override
    public void close() {
        super.close();
        this.getMinecraft().m_91152_(null);
    }

    @Override
    public void load() {
        ReplayModReplay.instance.getReplayHandler().getReplaySender().setReplaySpeed(0.0);
    }

    @Override
    protected File generateOutputFile(RenderSettings.EncodingPreset encodingPreset) {
        SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");
        File screenshotFolder = new File(this.getMinecraft().f_91069_, "screenshots");
        screenshotFolder.mkdirs();
        String baseName = DATE_FORMAT.format(new Date());
        int i = 1;
        File screenshotFile;
        while ((screenshotFile = new File(screenshotFolder, baseName + (String)(i == 1 ? "" : "_" + i) + ".png")).exists()) {
            ++i;
        }
        return screenshotFile;
    }

    @Override
    public void load(RenderSettings settings) {
        super.load(settings.withEncodingPreset(RenderSettings.EncodingPreset.PNG));
    }

    @Override
    protected Path getSettingsPath() {
        return this.getMinecraft().f_91069_.toPath().resolve("config/replaymod-screenshotsettings.json");
    }
}

