/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.core.versions.scheduler;

import com.replaymod.core.mixin.MinecraftAccessor;
import com.replaymod.core.versions.scheduler.Scheduler;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.util.thread.ReentrantBlockableEventLoop;

public class SchedulerImpl
implements Scheduler {
    private static final Minecraft mc = Minecraft.m_91087_();
    private boolean inRunLater = false;
    private boolean inRenderTaskQueue = false;
    public final ReplayModExecutor executor = new ReplayModExecutor("Client/ReplayMod");

    @Override
    public void runSync(Runnable runnable) throws InterruptedException, ExecutionException, TimeoutException {
        if (mc.m_18695_()) {
            runnable.run();
        } else {
            this.executor.m_18691_(() -> {
                runnable.run();
                return null;
            }).get(30L, TimeUnit.SECONDS);
        }
    }

    @Override
    public void runPostStartup(final Runnable runnable) {
        this.runLater(new Runnable(){

            @Override
            public void run() {
                if (mc.m_91265_() != null) {
                    SchedulerImpl.this.runLater(this);
                    return;
                }
                runnable.run();
            }
        });
    }

    @Override
    public void runTasks() {
        this.executor.m_18699_();
    }

    @Override
    public void runLaterWithoutLock(Runnable runnable) {
        this.runLater(runnable);
    }

    @Override
    public void runLater(Runnable runnable) {
        this.runLater(runnable, () -> this.runLater(runnable));
    }

    private void runLater(Runnable runnable, Runnable defer) {
        if (mc.m_18695_() && this.inRunLater && !this.inRenderTaskQueue) {
            ((MinecraftAccessor)mc).getRenderTaskQueue().offer(() -> {
                this.inRenderTaskQueue = true;
                try {
                    defer.run();
                }
                finally {
                    this.inRenderTaskQueue = false;
                }
            });
        } else {
            this.executor.m_6937_(() -> {
                this.inRunLater = true;
                try {
                    runnable.run();
                }
                catch (ReportedException e) {
                    e.printStackTrace();
                    System.err.println(e.m_134761_().m_127526_());
                    mc.m_231439_(e.m_134761_());
                }
                finally {
                    this.inRunLater = false;
                }
            });
        }
    }

    public static class ReplayModExecutor
    extends ReentrantBlockableEventLoop<Runnable> {
        private final Thread mcThread = Thread.currentThread();

        private ReplayModExecutor(String string_1) {
            super(string_1);
        }

        protected Runnable m_6681_(Runnable runnable) {
            return runnable;
        }

        protected boolean m_6362_(Runnable runnable) {
            return true;
        }

        protected Thread m_6304_() {
            return this.mcThread;
        }

        public void m_18699_() {
            super.m_18699_();
        }
    }
}

