/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.core.versions;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.replaymod.render.blend.mixin.ParticleAccessor;
import com.replaymod.render.mixin.MainWindowAccessor;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.packet.State;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.version.ProtocolVersion;
import com.replaymod.replaystudio.protocol.PacketTypeRegistry;
import de.johni0702.minecraft.gui.utils.lwjgl.vector.Vector2f;
import de.johni0702.minecraft.gui.utils.lwjgl.vector.Vector3f;
import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.particle.Particle;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class MCVer {
    private static Boolean hasOptifine;

    public static int getProtocolVersion() {
        return SharedConstants.m_183709_().m_132495_();
    }

    public static ConnectionProtocol asMc(State state) {
        switch (state) {
            case HANDSHAKE: {
                return ConnectionProtocol.HANDSHAKING;
            }
            case STATUS: {
                return ConnectionProtocol.STATUS;
            }
            case LOGIN: {
                return ConnectionProtocol.LOGIN;
            }
            case PLAY: {
                return ConnectionProtocol.PLAY;
            }
        }
        throw new IllegalArgumentException("Unexpected value: " + state);
    }

    public static State fromMc(ConnectionProtocol mcState) {
        switch (mcState) {
            case HANDSHAKING: {
                return State.HANDSHAKE;
            }
            case STATUS: {
                return State.STATUS;
            }
            case LOGIN: {
                return State.LOGIN;
            }
            case PLAY: {
                return State.PLAY;
            }
        }
        throw new IllegalArgumentException("Unexpected value: " + mcState);
    }

    public static PacketTypeRegistry getPacketTypeRegistry(ConnectionProtocol state) {
        return MCVer.getPacketTypeRegistry(MCVer.fromMc(state));
    }

    public static PacketTypeRegistry getPacketTypeRegistry(State state) {
        return PacketTypeRegistry.get(ProtocolVersion.getProtocol(MCVer.getProtocolVersion()), state);
    }

    public static PacketTypeRegistry getPacketTypeRegistry(boolean loginPhase) {
        return PacketTypeRegistry.get(ProtocolVersion.getProtocol(MCVer.getProtocolVersion()), loginPhase ? State.LOGIN : State.PLAY);
    }

    public static void resizeMainWindow(Minecraft mc, int width, int height) {
        Window window = mc.m_91268_();
        MainWindowAccessor mainWindow = (MainWindowAccessor)window;
        mainWindow.invokeOnFramebufferSizeChanged(window.m_85439_(), width, height);
    }

    public static CompletableFuture<?> setServerResourcePack(File file) {
        return MCVer.getMinecraft().m_247489_().m_247526_(file, PackSource.f_10530_);
    }

    public static <T> void addCallback(CompletableFuture<T> future, Consumer<T> success, Consumer<Throwable> failure) {
        ((CompletableFuture)future.thenAccept((Consumer)success)).exceptionally(throwable -> {
            failure.accept((Throwable)throwable);
            return null;
        });
    }

    public static List<VertexFormatElement> getElements(VertexFormat vertexFormat) {
        return vertexFormat.m_86023_();
    }

    public static Minecraft getMinecraft() {
        return Minecraft.m_91087_();
    }

    public static void addButton(Screen screen, Button button) {
        screen.m_142416_((GuiEventListener)button);
    }

    public static Optional<AbstractWidget> findButton(Iterable<? extends GuiEventListener> buttonList, String text, int id) {
        MutableComponent message = Component.m_237115_((String)text);
        for (GuiEventListener guiEventListener : buttonList) {
            Optional<AbstractWidget> button;
            if (guiEventListener instanceof ContainerEventHandler && (button = MCVer.findButton(((ContainerEventHandler)guiEventListener).m_6702_(), text, id)).isPresent()) {
                return button;
            }
            if (!(guiEventListener instanceof AbstractWidget)) continue;
            AbstractWidget b = (AbstractWidget)guiEventListener;
            if (message.equals(b.m_6035_())) {
                return Optional.of(b);
            }
            if (b.m_6035_() == null || !b.m_6035_().m_6879_().equals((Object)message)) continue;
            return Optional.of(b);
        }
        return Optional.empty();
    }

    public static void processKeyBinds() {
        ((MinecraftMethodAccessor)MCVer.getMinecraft()).replayModProcessKeyBinds();
    }

    public static long milliTime() {
        return Util.m_137550_();
    }

    public static Vec3 getPosition(Particle particle, float partialTicks) {
        ParticleAccessor acc = (ParticleAccessor)particle;
        double x = acc.getPrevPosX() + (acc.getPosX() - acc.getPrevPosX()) * (double)partialTicks;
        double y = acc.getPrevPosY() + (acc.getPosY() - acc.getPrevPosY()) * (double)partialTicks;
        double z = acc.getPrevPosZ() + (acc.getPosZ() - acc.getPrevPosZ()) * (double)partialTicks;
        return new Vec3(x, y, z);
    }

    public static void openFile(File file) {
        Util.m_137581_().m_137644_(file);
    }

    public static void openURL(URI url) {
        Util.m_137581_().m_137648_(url);
    }

    public static void pushMatrix() {
        RenderSystem.getModelViewStack().m_85836_();
    }

    public static void popMatrix() {
        RenderSystem.getModelViewStack().m_85849_();
        RenderSystem.applyModelViewMatrix();
    }

    public static Quaternionf quaternion(float angle, org.joml.Vector3f axis) {
        return new Quaternionf().fromAxisAngleDeg(axis.x, axis.y, axis.z, angle);
    }

    public static Matrix4f ortho(float left, float right, float top, float bottom, float zNear, float zFar) {
        return new Matrix4f().ortho(left, right, bottom, top, zNear, zFar);
    }

    public static void emitLine(BufferBuilder buffer, Vector2f p1, Vector2f p2, int color) {
        MCVer.emitLine(buffer, new Vector3f(p1.x, p1.y, 0.0f), new Vector3f(p2.x, p2.y, 0.0f), color);
    }

    public static void emitLine(BufferBuilder buffer, Vector3f p1, Vector3f p2, int color) {
        int r = color >> 24 & 0xFF;
        int g = color >> 16 & 0xFF;
        int b = color >> 8 & 0xFF;
        int a = color & 0xFF;
        Vector3f n = Vector3f.sub((Vector3f)p2, (Vector3f)p1, null);
        buffer.m_5483_((double)p1.x, (double)p1.y, (double)p1.z).m_6122_(r, g, b, a).m_5601_(n.x, n.y, n.z).m_5752_();
        buffer.m_5483_((double)p2.x, (double)p2.y, (double)p2.z).m_6122_(r, g, b, a).m_5601_(n.x, n.y, n.z).m_5752_();
    }

    public static void bindTexture(ResourceLocation id) {
        de.johni0702.minecraft.gui.versions.MCVer.bindTexture(id);
    }

    public static boolean hasOptifine() {
        if (hasOptifine == null) {
            try {
                Class.forName("Config");
                hasOptifine = true;
            }
            catch (ClassNotFoundException e) {
                hasOptifine = false;
            }
        }
        return hasOptifine;
    }

    public static interface MinecraftMethodAccessor {
        public void replayModProcessKeyBinds();

        public void replayModExecuteTaskQueue();
    }

    public static abstract class Keyboard {
        public static final int KEY_LCONTROL = 341;
        public static final int KEY_LSHIFT = 340;
        public static final int KEY_ESCAPE = 256;
        public static final int KEY_HOME = 268;
        public static final int KEY_END = 269;
        public static final int KEY_UP = 265;
        public static final int KEY_DOWN = 264;
        public static final int KEY_LEFT = 263;
        public static final int KEY_RIGHT = 262;
        public static final int KEY_BACK = 259;
        public static final int KEY_DELETE = 261;
        public static final int KEY_RETURN = 257;
        public static final int KEY_TAB = 258;
        public static final int KEY_F1 = 290;
        public static final int KEY_A = 65;
        public static final int KEY_B = 66;
        public static final int KEY_C = 67;
        public static final int KEY_D = 68;
        public static final int KEY_E = 69;
        public static final int KEY_F = 70;
        public static final int KEY_G = 71;
        public static final int KEY_H = 72;
        public static final int KEY_I = 73;
        public static final int KEY_J = 74;
        public static final int KEY_K = 75;
        public static final int KEY_L = 76;
        public static final int KEY_M = 77;
        public static final int KEY_N = 78;
        public static final int KEY_O = 79;
        public static final int KEY_P = 80;
        public static final int KEY_Q = 81;
        public static final int KEY_R = 82;
        public static final int KEY_S = 83;
        public static final int KEY_T = 84;
        public static final int KEY_U = 85;
        public static final int KEY_V = 86;
        public static final int KEY_W = 87;
        public static final int KEY_X = 88;
        public static final int KEY_Y = 89;
        public static final int KEY_Z = 90;

        public static boolean hasControlDown() {
            return Screen.m_96637_();
        }

        public static boolean isKeyDown(int keyCode) {
            return InputConstants.m_84830_((long)MCVer.getMinecraft().m_91268_().m_85439_(), (int)keyCode);
        }
    }
}

