/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.core.versions;

import com.google.gson.Gson;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraftforge.fml.loading.LoadingModList;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import org.apache.commons.io.IOUtils;

public class LangResourcePack
extends AbstractPackResources {
    private static final Gson GSON = new Gson();
    public static final String NAME = "replaymod_lang";
    private static final Pattern JSON_FILE_PATTERN = Pattern.compile("^assets/replaymod/lang/([a-z][a-z])_([a-z][a-z]).json$");
    private static final Pattern LANG_FILE_NAME_PATTERN = Pattern.compile("^([a-z][a-z])_([a-z][a-z]).lang$");
    public static final String LEGACY_KEY_PREFIX = "replaymod.input.";
    private static final String FABRIC_KEY_FORMAT = "key.replaymod.%s";
    private final Path basePath;

    public LangResourcePack() {
        super(NAME, true);
        ModFileInfo container = LoadingModList.get().getModFileById("replaymod");
        if (container == null) {
            throw new IllegalStateException("Could not find ReplayMod container for replaymod");
        }
        this.basePath = container.getFile().getSecureJar().getRootPath();
    }

    private String langName(String path) {
        Matcher matcher = JSON_FILE_PATTERN.matcher(path);
        if (!matcher.matches()) {
            return null;
        }
        return String.format("%s_%s.lang", matcher.group(1), matcher.group(2).toUpperCase());
    }

    private Path baseLangPath() {
        return this.basePath.resolve("assets").resolve("replaymod").resolve("lang");
    }

    private Path langPath(String path) {
        String langName = this.langName(path);
        if (langName == null) {
            return null;
        }
        Path basePath = this.baseLangPath();
        return basePath.resolve(langName);
    }

    private String convertValue(String value) {
        return value;
    }

    public IoSupplier<InputStream> m_8017_(String ... segments) {
        byte[] bytes;
        try {
            bytes = this.readFile(String.join((CharSequence)"/", segments));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (bytes == null) {
            return null;
        }
        return () -> new ByteArrayInputStream(bytes);
    }

    public IoSupplier<InputStream> m_214146_(PackType type, ResourceLocation id) {
        return this.m_8017_(type.m_10305_(), id.m_135827_(), id.m_135815_());
    }

    private byte[] readFile(String path) throws IOException {
        List langFile;
        if ("pack.mcmeta".equals(path)) {
            return "{\"pack\": {\"description\": \"ReplayMod language files\", \"pack_format\": 4}}".getBytes(StandardCharsets.UTF_8);
        }
        Path langPath = this.langPath(path);
        if (langPath == null) {
            return null;
        }
        try (InputStream in = Files.newInputStream(langPath, new OpenOption[0]);){
            langFile = IOUtils.readLines((InputStream)in, (Charset)StandardCharsets.UTF_8);
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        for (String line : langFile) {
            if (line.trim().isEmpty() || line.trim().startsWith("#")) continue;
            int i = line.indexOf(61);
            String key = line.substring(0, i);
            String value = line.substring(i + 1);
            value = this.convertValue(value);
            if (key.startsWith(LEGACY_KEY_PREFIX)) {
                properties.put(key, value);
                key = String.format(FABRIC_KEY_FORMAT, key.substring(LEGACY_KEY_PREFIX.length()));
            }
            properties.put(key, value);
        }
        return GSON.toJson(properties).getBytes(StandardCharsets.UTF_8);
    }

    public void m_8031_(PackType type, String namespace, String prefix, PackResources.ResourceOutput consumer) {
        this.findResources(type, prefix, id -> consumer.accept(id, () -> new ByteArrayInputStream(Objects.requireNonNull(this.readFile(id.m_135815_())))));
    }

    private void findResources(PackType type, String path, Consumer<ResourceLocation> consumer) {
        if (type != PackType.CLIENT_RESOURCES) {
            return;
        }
        if (!"lang".equals(path)) {
            return;
        }
        Path base = this.baseLangPath();
        try (Stream<Path> stream = Files.walk(base, 1, new FileVisitOption[0]);){
            stream.skip(1L).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::getFileName).map(Path::toString).map(LANG_FILE_NAME_PATTERN::matcher).filter(Matcher::matches).map(matcher -> String.format("%s_%s.json", matcher.group(1), matcher.group(1))).map(name -> new ResourceLocation("replaymod", "lang/" + name)).forEach(consumer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Set<String> m_5698_(PackType resourcePackType) {
        if (resourcePackType == PackType.CLIENT_RESOURCES) {
            return Collections.singleton("replaymod");
        }
        return Collections.emptySet();
    }

    public void close() {
    }
}

