/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.core.gui;

import com.google.common.io.Files;
import com.google.gson.Gson;
import com.replaymod.core.ReplayMod;
import com.replaymod.core.versions.MCVer;
import com.replaymod.replaystudio.io.ReplayInputStream;
import com.replaymod.replaystudio.io.ReplayOutputStream;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.packet.State;
import com.replaymod.replaystudio.replay.ReplayFile;
import com.replaymod.replaystudio.replay.ReplayMetaData;
import com.replaymod.replaystudio.util.Utils;
import de.johni0702.minecraft.gui.container.AbstractGuiScreen;
import de.johni0702.minecraft.gui.container.GuiPanel;
import de.johni0702.minecraft.gui.container.GuiScreen;
import de.johni0702.minecraft.gui.container.VanillaGuiScreen;
import de.johni0702.minecraft.gui.element.GuiButton;
import de.johni0702.minecraft.gui.element.GuiElement;
import de.johni0702.minecraft.gui.element.GuiLabel;
import de.johni0702.minecraft.gui.element.advanced.GuiProgressBar;
import de.johni0702.minecraft.gui.layout.CustomLayout;
import de.johni0702.minecraft.gui.layout.HorizontalLayout;
import de.johni0702.minecraft.gui.layout.VerticalLayout;
import de.johni0702.minecraft.gui.utils.Colors;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Consumer;
import net.minecraft.CrashReport;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RestoreReplayGui
extends AbstractGuiScreen<RestoreReplayGui> {
    private static Logger LOGGER = LogManager.getLogger();
    public final GuiScreen parent;
    public final File file;
    public final GuiPanel textPanel = (GuiPanel)new GuiPanel().setLayout(new VerticalLayout().setSpacing(3));
    public final GuiPanel buttonPanel = (GuiPanel)new GuiPanel().setLayout(new HorizontalLayout().setSpacing(5));
    public final GuiPanel contentPanel = (GuiPanel)((GuiPanel)new GuiPanel(this).addElements(new VerticalLayout.Data(0.5), new GuiElement[]{this.textPanel, this.buttonPanel})).setLayout(new VerticalLayout().setSpacing(20));
    public final GuiButton yesButton = (GuiButton)((GuiButton)new GuiButton(this.buttonPanel).setSize(150, 20)).setI18nLabel("gui.yes", new Object[0]);
    public final GuiButton noButton = (GuiButton)((GuiButton)new GuiButton(this.buttonPanel).setSize(150, 20)).setI18nLabel("gui.no", new Object[0]);
    private final ReplayMod core;

    public RestoreReplayGui(ReplayMod core, GuiScreen parent, File file) {
        this.core = core;
        this.parent = parent;
        this.file = file;
        this.textPanel.addElements(new VerticalLayout.Data(0.5), new GuiElement[]{new GuiLabel().setI18nText("replaymod.gui.restorereplay1", new Object[0]), new GuiLabel().setI18nText("replaymod.gui.restorereplay2", new Object[]{Files.getNameWithoutExtension((String)file.getName())}), new GuiLabel().setI18nText("replaymod.gui.restorereplay3", new Object[0])});
        LOGGER.info("Found partially saved replay, offering recovery: " + file);
        this.yesButton.onClick(() -> {
            LOGGER.info("Attempting recovery: " + file);
            this.recoverInBackground();
            parent.display();
        });
        this.noButton.onClick(() -> {
            LOGGER.info("Recovery rejected, marking for deletion: " + file);
            try {
                File tmp = new File(file.getParentFile(), file.getName() + ".tmp");
                File deleted = new File(file.getParentFile(), file.getName() + ".del");
                if (deleted.exists()) {
                    FileUtils.deleteDirectory((File)deleted);
                }
                Files.move((File)tmp, (File)deleted);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            parent.display();
        });
        this.setLayout(new CustomLayout<RestoreReplayGui>(){

            @Override
            protected void layout(RestoreReplayGui container, int width, int height) {
                this.pos(RestoreReplayGui.this.contentPanel, width / 2 - this.width(RestoreReplayGui.this.contentPanel) / 2, height / 2 - this.height(RestoreReplayGui.this.contentPanel) / 2);
            }
        });
    }

    @Override
    protected RestoreReplayGui getThis() {
        return this;
    }

    private void recoverInBackground() {
        GuiLabel label = (GuiLabel)((GuiLabel)new GuiLabel().setI18nText("replaymod.gui.replaysaving.title", new Object[0])).setColor(Colors.BLACK);
        GuiProgressBar progressBar = (GuiProgressBar)new GuiProgressBar().setHeight(14);
        GuiPanel savingProcess = (GuiPanel)((GuiPanel)new GuiPanel().setLayout(new VerticalLayout())).addElements(new VerticalLayout.Data(0.5), new GuiElement[]{label, progressBar});
        new Thread(() -> {
            this.core.runLater(() -> this.core.getBackgroundProcesses().addProcess(savingProcess));
            try {
                this.tryRecover(progressBar::setProgress);
            }
            catch (IOException e) {
                LOGGER.error("Recovering replay file:", (Throwable)e);
                CrashReport crashReport = CrashReport.m_127521_((Throwable)e, (String)"Recovering replay file");
                this.core.runLater(() -> com.replaymod.core.utils.Utils.error(LOGGER, VanillaGuiScreen.wrap(this.getMinecraft().f_91080_), crashReport, () -> {}));
            }
            finally {
                this.core.runLater(() -> this.core.getBackgroundProcesses().removeProcess(savingProcess));
            }
        }).start();
    }

    private void tryRecover(Consumer<Float> progress) throws IOException {
        ReplayFile replayFile = ReplayMod.instance.files.open(this.file.toPath());
        replayFile.save();
        progress.accept(Float.valueOf(0.4f));
        ReplayMetaData metaData = replayFile.getMetaData();
        if (metaData != null && metaData.getDuration() == 0) {
            try (ReplayInputStream in = replayFile.getPacketData(MCVer.getPacketTypeRegistry(State.LOGIN));
                 ReplayOutputStream out = replayFile.writePacketData();){
                while (true) {
                    int time = Utils.readInt(in);
                    int length = Utils.readInt(in);
                    if (time == -1) break;
                    if (length == -1) {
                        break;
                    }
                    byte[] buf = new byte[length];
                    IOUtils.readFully((InputStream)in, (byte[])buf);
                    metaData.setDuration(time);
                    Utils.writeInt(out, time);
                    Utils.writeInt(out, length);
                    out.write(buf);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            try (OutputStream out = replayFile.write("metaData.json");){
                metaData.setGenerator(metaData.getGenerator() + "(+ ReplayMod Replay Recovery)");
                String json = new Gson().toJson((Object)metaData);
                out.write(json.getBytes());
            }
        }
        progress.accept(Float.valueOf(0.6f));
        replayFile.save();
        progress.accept(Float.valueOf(0.9f));
        replayFile.close();
        progress.accept(Float.valueOf(1.0f));
    }
}

