/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.core;

import com.replaymod.compat.ReplayModCompat;
import com.replaymod.core.KeyBindingRegistry;
import com.replaymod.core.Module;
import com.replaymod.core.ReplayModBackend;
import com.replaymod.core.Setting;
import com.replaymod.core.SettingsRegistry;
import com.replaymod.core.files.ReplayFilesService;
import com.replaymod.core.files.ReplayFoldersService;
import com.replaymod.core.gui.GuiBackgroundProcesses;
import com.replaymod.core.gui.GuiReplaySettings;
import com.replaymod.core.versions.MCVer;
import com.replaymod.core.versions.scheduler.Scheduler;
import com.replaymod.core.versions.scheduler.SchedulerImpl;
import com.replaymod.editor.ReplayModEditor;
import com.replaymod.extras.ReplayModExtras;
import com.replaymod.recording.ReplayModRecording;
import com.replaymod.render.ReplayModRender;
import com.replaymod.replay.ReplayModReplay;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.version.ProtocolVersion;
import com.replaymod.replaystudio.studio.ReplayStudio;
import com.replaymod.replaystudio.util.I18n;
import com.replaymod.simplepathing.ReplayModSimplePathing;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.resources.IoSupplier;

public class ReplayMod
implements Module,
Scheduler {
    public static final String MOD_ID = "replaymod";
    public static final ResourceLocation TEXTURE = new ResourceLocation("replaymod", "replay_gui.png");
    public static final int TEXTURE_SIZE = 256;
    public static final ResourceLocation LOGO_FAVICON = new ResourceLocation("replaymod", "favicon_logo.png");
    private static final Minecraft mc = MCVer.getMinecraft();
    private final ReplayModBackend backend;
    private final SchedulerImpl scheduler = new SchedulerImpl();
    private final KeyBindingRegistry keyBindingRegistry = new KeyBindingRegistry();
    private final SettingsRegistry settingsRegistry = new SettingsRegistry();
    public static ReplayMod instance;
    private final List<Module> modules;
    private final GuiBackgroundProcesses backgroundProcesses;
    public final ReplayFoldersService folders;
    public final ReplayFilesService files;
    private boolean minimalMode;
    public static final PathPackResources jGuiResourcePack;
    public static final String JGUI_RESOURCE_PACK_NAME = "replaymod_jgui";

    public ReplayMod(ReplayModBackend backend) {
        this.settingsRegistry.register(Setting.class);
        instance = this;
        this.modules = new ArrayList<Module>();
        this.backgroundProcesses = new GuiBackgroundProcesses();
        this.folders = new ReplayFoldersService(this.settingsRegistry);
        this.files = new ReplayFilesService(this.folders);
        this.backend = backend;
        I18n.setI18n(net.minecraft.client.resources.language.I18n::m_118938_);
        if (!ProtocolVersion.isRegistered(MCVer.getProtocolVersion()) && !Boolean.parseBoolean(System.getProperty("replaymod.skipversioncheck", "false"))) {
            this.minimalMode = true;
        }
        this.modules.add(this);
        this.modules.add(new ReplayModRecording(this));
        ReplayModReplay replayModule = new ReplayModReplay(this);
        this.modules.add(replayModule);
        this.modules.add(new ReplayModRender(this));
        this.modules.add(new ReplayModSimplePathing(this));
        this.modules.add(new ReplayModEditor(this));
        this.modules.add(new ReplayModExtras(this));
        this.modules.add(new ReplayModCompat());
        this.settingsRegistry.register();
    }

    public KeyBindingRegistry getKeyBindingRegistry() {
        return this.keyBindingRegistry;
    }

    public SettingsRegistry getSettingsRegistry() {
        return this.settingsRegistry;
    }

    private static PathPackResources createJGuiResourcePack() {
        File folder = new File("../jGui/src/main/resources");
        if (!folder.exists() && !(folder = new File("../../../jGui/src/main/resources")).exists()) {
            return null;
        }
        return new PathPackResources(JGUI_RESOURCE_PACK_NAME, folder.toPath(), true){

            public String m_5542_() {
                return ReplayMod.JGUI_RESOURCE_PACK_NAME;
            }

            public IoSupplier<InputStream> m_8017_(String ... segments) {
                if (segments.length == 1 && segments[0].equals("pack.mcmeta")) {
                    return () -> new ByteArrayInputStream(this.generatePackMeta());
                }
                return super.m_8017_(segments);
            }

            private byte[] generatePackMeta() {
                int version = 4;
                return ("{\"pack\": {\"description\": \"dummy pack for jGui resources in dev-env\", \"pack_format\": " + version + "}}").getBytes(StandardCharsets.UTF_8);
            }
        };
    }

    void initModules() {
        this.modules.forEach(Module::initCommon);
        this.modules.forEach(Module::initClient);
        this.modules.forEach(m -> m.registerKeyBindings(this.keyBindingRegistry));
    }

    @Override
    public void registerKeyBindings(KeyBindingRegistry registry) {
        registry.registerKeyBinding("replaymod.input.settings", 0, () -> new GuiReplaySettings(null, this.settingsRegistry).display(), false);
    }

    @Override
    public void initClient() {
        this.backgroundProcesses.register();
        this.keyBindingRegistry.register();
        this.runPostStartup(() -> this.files.initialScan(this));
    }

    @Override
    public void runSync(Runnable runnable) throws InterruptedException, ExecutionException, TimeoutException {
        this.scheduler.runSync(runnable);
    }

    @Override
    public void runPostStartup(Runnable runnable) {
        this.scheduler.runPostStartup(runnable);
    }

    @Override
    public void runLaterWithoutLock(Runnable runnable) {
        this.scheduler.runLaterWithoutLock(runnable);
    }

    @Override
    public void runLater(Runnable runnable) {
        this.scheduler.runLater(runnable);
    }

    @Override
    public void runTasks() {
        this.scheduler.runTasks();
    }

    public String getVersion() {
        return this.backend.getVersion();
    }

    public String getMinecraftVersion() {
        return this.backend.getMinecraftVersion();
    }

    public boolean isModLoaded(String id) {
        return this.backend.isModLoaded(id);
    }

    public Minecraft getMinecraft() {
        return mc;
    }

    public void printInfoToChat(String message, Object ... args) {
        this.printToChat(false, message, args);
    }

    public void printWarningToChat(String message, Object ... args) {
        this.printToChat(true, message, args);
    }

    private void printToChat(boolean warning, String message, Object ... args) {
        if (this.getSettingsRegistry().get(Setting.NOTIFICATIONS).booleanValue()) {
            Style coloredDarkGray = Style.f_131099_.m_131140_(ChatFormatting.DARK_GRAY);
            Style coloredGold = Style.f_131099_.m_131140_(ChatFormatting.GOLD);
            Style alert = Style.f_131099_.m_131140_(warning ? ChatFormatting.RED : ChatFormatting.DARK_GREEN);
            MutableComponent text = Component.m_237113_((String)"[").m_6270_(coloredDarkGray).m_7220_((Component)Component.m_237115_((String)"replaymod.title").m_6270_(coloredGold)).m_7220_((Component)Component.m_237113_((String)"] ")).m_7220_((Component)Component.m_237110_((String)message, (Object[])args).m_6270_(alert));
            ReplayMod.mc.f_91065_.m_93076_().m_93785_((Component)text);
        }
    }

    public GuiBackgroundProcesses getBackgroundProcesses() {
        return this.backgroundProcesses;
    }

    public static boolean isMinimalMode() {
        return ReplayMod.instance.minimalMode;
    }

    public static boolean isCompatible(int fileFormatVersion, int protocolVersion) {
        if (ReplayMod.isMinimalMode()) {
            return protocolVersion == MCVer.getProtocolVersion();
        }
        return new ReplayStudio().isCompatible(fileFormatVersion, protocolVersion, MCVer.getProtocolVersion());
    }

    static {
        jGuiResourcePack = ReplayMod.createJGuiResourcePack();
    }
}

