/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.packetlib.tcp;

import com.github.steveice10.netty.bootstrap.Bootstrap;
import com.github.steveice10.netty.channel.Channel;
import com.github.steveice10.netty.channel.ChannelFuture;
import com.github.steveice10.netty.channel.ChannelHandler;
import com.github.steveice10.netty.channel.ChannelInitializer;
import com.github.steveice10.netty.channel.ChannelOption;
import com.github.steveice10.netty.channel.ChannelPipeline;
import com.github.steveice10.netty.channel.EventLoopGroup;
import com.github.steveice10.netty.channel.nio.NioEventLoopGroup;
import com.github.steveice10.netty.channel.socket.nio.NioSocketChannel;
import com.github.steveice10.netty.handler.proxy.HttpProxyHandler;
import com.github.steveice10.netty.handler.proxy.Socks4ProxyHandler;
import com.github.steveice10.netty.handler.proxy.Socks5ProxyHandler;
import com.github.steveice10.packetlib.Client;
import com.github.steveice10.packetlib.ProxyInfo;
import com.github.steveice10.packetlib.packet.PacketProtocol;
import com.github.steveice10.packetlib.tcp.TcpPacketCodec;
import com.github.steveice10.packetlib.tcp.TcpPacketEncryptor;
import com.github.steveice10.packetlib.tcp.TcpPacketSizer;
import com.github.steveice10.packetlib.tcp.TcpSession;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;
import org.xbill.DNS.SRVRecord;
import org.xbill.DNS.TextParseException;

public class TcpClientSession
extends TcpSession {
    private Client client;
    private ProxyInfo proxy;
    private EventLoopGroup group;

    public TcpClientSession(String host, int port, PacketProtocol protocol, Client client, ProxyInfo proxy) {
        super(host, port, protocol);
        this.client = client;
        this.proxy = proxy;
    }

    @Override
    public void connect(boolean wait) {
        if (this.disconnected) {
            throw new IllegalStateException("Session has already been disconnected.");
        }
        if (this.group != null) {
            return;
        }
        try {
            this.group = new NioEventLoopGroup();
            final Bootstrap bootstrap = new Bootstrap();
            bootstrap.channel(NioSocketChannel.class);
            ((Bootstrap)((Bootstrap)bootstrap.handler(new ChannelInitializer<Channel>(){

                @Override
                public void initChannel(Channel channel) throws Exception {
                    TcpClientSession.this.getPacketProtocol().newClientSession(TcpClientSession.this.client, TcpClientSession.this);
                    channel.config().setOption(ChannelOption.IP_TOS, 24);
                    channel.config().setOption(ChannelOption.TCP_NODELAY, false);
                    ChannelPipeline pipeline = channel.pipeline();
                    TcpClientSession.this.refreshReadTimeoutHandler(channel);
                    TcpClientSession.this.refreshWriteTimeoutHandler(channel);
                    if (TcpClientSession.this.proxy != null) {
                        switch (TcpClientSession.this.proxy.getType()) {
                            case HTTP: {
                                if (TcpClientSession.this.proxy.isAuthenticated()) {
                                    pipeline.addFirst("proxy", (ChannelHandler)new HttpProxyHandler(TcpClientSession.this.proxy.getAddress(), TcpClientSession.this.proxy.getUsername(), TcpClientSession.this.proxy.getPassword()));
                                    break;
                                }
                                pipeline.addFirst("proxy", (ChannelHandler)new HttpProxyHandler(TcpClientSession.this.proxy.getAddress()));
                                break;
                            }
                            case SOCKS4: {
                                if (TcpClientSession.this.proxy.isAuthenticated()) {
                                    pipeline.addFirst("proxy", (ChannelHandler)new Socks4ProxyHandler(TcpClientSession.this.proxy.getAddress(), TcpClientSession.this.proxy.getUsername()));
                                    break;
                                }
                                pipeline.addFirst("proxy", (ChannelHandler)new Socks4ProxyHandler(TcpClientSession.this.proxy.getAddress()));
                                break;
                            }
                            case SOCKS5: {
                                if (TcpClientSession.this.proxy.isAuthenticated()) {
                                    pipeline.addFirst("proxy", (ChannelHandler)new Socks5ProxyHandler(TcpClientSession.this.proxy.getAddress(), TcpClientSession.this.proxy.getUsername(), TcpClientSession.this.proxy.getPassword()));
                                    break;
                                }
                                pipeline.addFirst("proxy", (ChannelHandler)new Socks5ProxyHandler(TcpClientSession.this.proxy.getAddress()));
                                break;
                            }
                            default: {
                                throw new UnsupportedOperationException("Unsupported proxy type: " + (Object)((Object)TcpClientSession.this.proxy.getType()));
                            }
                        }
                    }
                    pipeline.addLast("encryption", (ChannelHandler)new TcpPacketEncryptor(TcpClientSession.this));
                    pipeline.addLast("sizer", (ChannelHandler)new TcpPacketSizer(TcpClientSession.this));
                    pipeline.addLast("codec", (ChannelHandler)new TcpPacketCodec(TcpClientSession.this));
                    pipeline.addLast("manager", (ChannelHandler)TcpClientSession.this);
                }
            })).group(this.group)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, this.getConnectTimeout() * 1000);
            Runnable connectTask = new Runnable(){

                @Override
                public void run() {
                    try {
                        String host = TcpClientSession.this.getHost();
                        int port = TcpClientSession.this.getPort();
                        try {
                            Record[] records = new Lookup(TcpClientSession.this.getPacketProtocol().getSRVRecordPrefix() + "._tcp." + host, 33).run();
                            if (records != null && records.length > 0) {
                                SRVRecord srv = (SRVRecord)records[0];
                                host = srv.getTarget().toString().replaceFirst("\\.$", "");
                                port = srv.getPort();
                            }
                        }
                        catch (TextParseException records) {
                            // empty catch block
                        }
                        bootstrap.remoteAddress(host, port);
                        ChannelFuture future = bootstrap.connect().sync();
                        if (future.isSuccess()) {
                            while (!TcpClientSession.this.isConnected() && !TcpClientSession.this.disconnected) {
                                try {
                                    Thread.sleep(5L);
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                        }
                    }
                    catch (Throwable t) {
                        TcpClientSession.this.exceptionCaught(null, t);
                    }
                }
            };
            if (wait) {
                connectTask.run();
            } else {
                new Thread(connectTask).start();
            }
        }
        catch (Throwable t) {
            this.exceptionCaught(null, t);
        }
    }

    @Override
    public void disconnect(String reason, Throwable cause) {
        super.disconnect(reason, cause);
        if (this.group != null) {
            this.group.shutdownGracefully();
            this.group = null;
        }
    }
}

